/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.utils.rdbms.hsql;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.exception.SDXExceptionCode;
import fr.gouv.culture.sdx.utils.SdxObjectImpl;
import fr.gouv.culture.sdx.utils.Utilities;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;


/**
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: Feb 28, 2003
 * Time: 10:47:59 AM
 * To change this template use Options | File Templates.
 */
public class HSQLDB extends SdxObjectImpl {

    protected final String HSQLDB_DRIVER = "org.hsqldb.jdbcDriver";
    protected final String PROTOCOL_PREFIX = "jdbc:hsqldb:";

    protected String dbDirPath = null;
    protected String tableName = null;
    protected String tableCreationQuery = null;

    private Connection conn;

    public HSQLDB() throws ClassNotFoundException {
        // Load the HSQL Database Engine JDBC driver
        // hsqldb.jar should be in the class path or made part of the current jar
        Class.forName(HSQLDB_DRIVER);

    }

    public void setDbDirPath(String dbDirPath) throws SDXException {
        this.dbDirPath = dbDirPath;
        getSQLConnection();//getting a connection
    }


    public String getDbDirPath() {
        return dbDirPath;
    }

    public synchronized Connection getSQLConnection() throws SDXException {
        // connect to the database.   This will load the db files and start the
        // database if it is not alread running.
        // db_file_name_prefix is used to open or create files that hold the state
        // of the db.
        // It can contain directory names relative to the
        // current working directory
        if (this.conn != null) return this.conn;
        try {
            if (!Utilities.checkString(dbDirPath))
            //TODOException?: better message here
                throw new SQLException("the db directory path for this db instance is not set");
            Connection conn = DriverManager.getConnection(PROTOCOL_PREFIX + dbDirPath, // filenames
                    "sa", // username
                    "");                     // password
            this.conn = conn;
            return conn;
        } catch (SQLException e) {
            String[] args = new String[1];
            args[0] = this.dbDirPath;
            throw new SDXException(logger, SDXExceptionCode.ERROR_GET_HSQLDB_CONNECTION, args, e);
        }
    }

    protected void finalize() throws Throwable {
        if (this.conn != null)
            this.conn.close();
        //TODO: maybe use a "SHUTDOWN COMPACT" prepared statement here to backup data before the object if finalized
    }


}
