/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.beans;

import java.util.Locale;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.BeanAttributeIterator;
import org.apache.commons.jxpath.ri.model.beans.PropertyIterator;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;
import org.apache.commons.jxpath.util.ValueUtils;

public abstract class PropertyOwnerPointer
extends NodePointer {
    private static final Object UNINITIALIZED = new Object();
    private Object value = UNINITIALIZED;

    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        if (test == null) {
            return new PropertyIterator(this, null, reverse, startWith);
        }
        if (test instanceof NodeNameTest) {
            QName testName = ((NodeNameTest)test).getNodeName();
            if (!this.isDefaultNamespace(testName.getPrefix())) {
                return null;
            }
            String property = testName.getName().equals("*") ? null : testName.getName();
            return new PropertyIterator(this, property, reverse, startWith);
        }
        if (test instanceof NodeTypeTest && ((NodeTypeTest)test).getNodeType() == 1) {
            return new PropertyIterator(this, null, reverse, startWith);
        }
        return null;
    }

    public NodeIterator attributeIterator(QName name) {
        return new BeanAttributeIterator(this, name);
    }

    protected PropertyOwnerPointer(NodePointer parent, Locale locale) {
        super(parent, locale);
    }

    protected PropertyOwnerPointer(NodePointer parent) {
        super(parent);
    }

    public boolean isCollection() {
        Object value = this.getBaseValue();
        return value != null && ValueUtils.isCollection(value);
    }

    public void setIndex(int index) {
        if (this.index != index) {
            super.setIndex(index);
            this.value = UNINITIALIZED;
        }
    }

    public Object getNodeValue() {
        if (this.value == UNINITIALIZED) {
            this.value = this.index == NodePointer.WHOLE_COLLECTION ? this.getBaseValue() : ValueUtils.getValue(this.getBaseValue(), this.index);
        }
        return this.value;
    }

    public abstract QName getName();

    public void setValue(Object value) {
        this.value = value;
    }

    public abstract PropertyPointer getPropertyPointer();

    public NodePointer createChild(JXPathContext context, QName name, int index, Object value) {
        PropertyPointer prop = this.getPropertyPointer();
        prop.setPropertyName(name.getName());
        prop.setIndex(index);
        return prop.createPath(context, value);
    }

    public NodePointer createChild(JXPathContext context, QName name, int index) {
        PropertyPointer prop = this.getPropertyPointer();
        prop.setPropertyName(name.getName());
        prop.setIndex(index);
        return prop.createPath(context);
    }

    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        int r = pointer1.getName().toString().compareTo(pointer2.getName().toString());
        if (r != 0) {
            return r;
        }
        return pointer1.getIndex() - pointer2.getIndex();
    }
}

