/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query;

import com.hp.hpl.jena.rdf.query.RDQL_InternalErrorException;
import com.hp.hpl.jena.rdf.query.Sys;
import com.hp.hpl.jena.rdf.query.Value;
import com.hp.hpl.jena.rdf.query.WorkingVar;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ResultBinding {
    ResultBinding parent = null;
    List varNames = new ArrayList();
    List values = new ArrayList();

    public int add(String string, Value value) {
        Sys.assert(string != null, "Null variable name", "ResultBinding", "add");
        Sys.assert(this.varNames.size() == this.values.size(), "Lists out of step", "ResultBinding", "add");
        this.varNames.add(string);
        this.values.add(value);
        this.check();
        return this.varNames.size() - 1;
    }

    public int add(String string, RDFNode rDFNode) {
        Sys.assert(string != null, "Null variable name", "ResultBinding", "add");
        Sys.assert(this.varNames.size() == this.values.size(), "Lists out of step", "ResultBinding", "add");
        this.varNames.add(string);
        this.values.add(rDFNode);
        this.check();
        return this.varNames.size() - 1;
    }

    public ResultBindingIterator iterator() {
        return new ResultBindingIterator(this);
    }

    public Object get(String string) {
        Sys.assert(string != null, "Null variable name", "ResultBinding", "get");
        Sys.assert(this.varNames.size() == this.values.size(), "Lists out of step", "ResultBinding", "get");
        return this.lookup(string, 0);
    }

    private Object lookup(String string, int n) {
        int n2 = n;
        while (n2 < this.varNames.size()) {
            if (string.equals((String)this.varNames.get(n2))) {
                Object e = this.values.get(n2);
                return this.values.get(n2);
            }
            ++n2;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.lookup(string, 0);
    }

    public Value getValue(String string) {
        Object object = this.get(string);
        return ResultBinding.convert(object);
    }

    private static Value convert(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof Resource) {
            String string = ((Resource)object).getURI();
            WorkingVar workingVar = new WorkingVar();
            if (string == null || string.length() == 0) {
                try {
                    string = "anon:" + ((Resource)object).getId();
                }
                catch (RDFException rDFException) {
                    throw new RDQL_InternalErrorException("ResultBinding: error on anon resource");
                }
            }
            workingVar.setURI(string);
            return workingVar;
        }
        if (object instanceof RDFNode) {
            WorkingVar workingVar = new WorkingVar();
            workingVar.setString(object.toString());
            return workingVar;
        }
        throw new RDQL_InternalErrorException("ResultBinding: unexpected object class: " + object.getClass().getName());
    }

    public void setParent(ResultBinding resultBinding) {
        Sys.assert(this.parent == null, "Attempt to change parent", "ResultBinding", "setParent");
        this.parent = resultBinding;
    }

    public int size() {
        int n = this.varNames.size();
        if (this.parent != null) {
            n += this.parent.size();
        }
        return n;
    }

    public void check() {
        int n = 0;
        while (n < this.varNames.size()) {
            String string = (String)this.varNames.get(n);
            Object object = this.lookup(string, n + 1);
            Sys.assert(object == null, "Duplicate binding: " + this, "ResultBinding", "check");
            ++n;
        }
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < this.varNames.size()) {
            if (n != 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("(" + this.varNames.get(n) + ", " + this.values.get(n) + ")");
            ++n;
        }
        if (this.parent != null && (string = this.parent.toString()) != null && string.length() != 0) {
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static class ResultBindingIterator
    implements Iterator {
        boolean active;
        boolean doneThisOne;
        ResultBinding binding;
        int i;

        ResultBindingIterator(ResultBinding resultBinding) {
            this.binding = resultBinding;
            this.i = -1;
            this.doneThisOne = true;
            this.active = true;
        }

        public boolean hasNext() {
            if (this.doneThisOne) {
                this.advance();
            }
            return this.active;
        }

        public Object next() {
            this.advance();
            this.doneThisOne = true;
            return this.binding.varNames.get(this.i);
        }

        public String varName() {
            if (!this.active) {
                return null;
            }
            return (String)this.binding.varNames.get(this.i);
        }

        public Value value() {
            if (!this.active) {
                return null;
            }
            return ResultBinding.convert(this.binding.values.get(this.i));
        }

        public void remove() {
            throw new UnsupportedOperationException("ResultsBindingIterator.remove");
        }

        private boolean advance() {
            if (!this.active) {
                return false;
            }
            if (!this.doneThisOne) {
                return true;
            }
            ++this.i;
            if (this.i >= this.binding.varNames.size()) {
                this.i = -1;
                this.binding = this.binding.parent;
                this.doneThisOne = true;
                if (this.binding == null) {
                    this.active = false;
                    return this.active;
                }
                return this.advance();
            }
            this.doneThisOne = false;
            return this.active;
        }
    }
}

