/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.GenericAttr;
import org.apache.batik.dom.GenericAttrNS;
import org.apache.batik.dom.GenericCDATASection;
import org.apache.batik.dom.GenericComment;
import org.apache.batik.dom.GenericDocumentFragment;
import org.apache.batik.dom.GenericElement;
import org.apache.batik.dom.GenericEntityReference;
import org.apache.batik.dom.GenericProcessingInstruction;
import org.apache.batik.dom.GenericText;
import org.apache.batik.dom.StyleSheetFactory;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGStyleSheetProcessingInstruction;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.stylesheets.StyleSheetList;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGLangSpace;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;

public class SVGOMDocument
extends AbstractDocument
implements SVGDocument,
DocumentCSS,
DocumentView,
SVGConstants {
    protected static final String RESOURCES = "org.apache.batik.dom.svg.resources.Messages";
    protected transient LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.dom.svg.resources.Messages");
    protected String referrer = "";
    protected URL url;
    protected transient boolean readonly;
    protected transient AbstractView defaultView;
    protected transient CSSEngine cssEngine;

    protected SVGOMDocument() {
    }

    public SVGOMDocument(DocumentType documentType, DOMImplementation dOMImplementation) {
        super(dOMImplementation);
        if (documentType != null) {
            this.appendChild(documentType);
        }
    }

    public void setCSSEngine(CSSEngine cSSEngine) {
        this.cssEngine = cSSEngine;
    }

    public CSSEngine getCSSEngine() {
        return this.cssEngine;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.localizableSupport.setLocale(locale);
    }

    public String formatMessage(String string, Object[] objectArray) throws MissingResourceException {
        try {
            return super.formatMessage(string, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return this.localizableSupport.formatMessage(string, objectArray);
        }
    }

    public String getTitle() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (object = this.getDocumentElement().getFirstChild(); object != null; object = object.getNextSibling()) {
            String string = object.getNamespaceURI();
            if (string == null || !string.equals("http://www.w3.org/2000/svg") || !object.getLocalName().equals("title")) continue;
            bl = ((SVGLangSpace)object).getXMLspace().equals("preserve");
            for (object = object.getFirstChild(); object != null; object = object.getNextSibling()) {
                if (object.getNodeType() != 3) continue;
                stringBuffer.append(object.getNodeValue());
            }
            break;
        }
        object = stringBuffer.toString();
        return bl ? XMLSupport.preserveXMLSpace((String)object) : XMLSupport.defaultXMLSpace((String)object);
    }

    public String getReferrer() {
        return this.referrer;
    }

    public void setReferrer(String string) {
        this.referrer = string;
    }

    public String getDomain() {
        return this.url == null ? null : this.url.getHost();
    }

    public SVGSVGElement getRootElement() {
        return (SVGSVGElement)this.getDocumentElement();
    }

    public String getURL() {
        return this.url == null ? null : this.url.toString();
    }

    public URL getURLObject() {
        return this.url;
    }

    public void setURLObject(URL uRL) {
        this.url = uRL;
    }

    public Element createElement(String string) throws DOMException {
        return new GenericElement(string.intern(), this);
    }

    public DocumentFragment createDocumentFragment() {
        return new GenericDocumentFragment(this);
    }

    public Text createTextNode(String string) {
        return new GenericText(string, this);
    }

    public Comment createComment(String string) {
        return new GenericComment(string, this);
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        return new GenericCDATASection(string, this);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        if ("xml-stylesheet".equals(string)) {
            return new SVGStyleSheetProcessingInstruction(string2, this, (StyleSheetFactory)((Object)this.getImplementation()));
        }
        return new GenericProcessingInstruction(string, string2, this);
    }

    public Attr createAttribute(String string) throws DOMException {
        return new GenericAttr(string.intern(), this);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        return new GenericEntityReference(string, this);
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        if (string == null) {
            return new GenericAttr(string2.intern(), this);
        }
        return new GenericAttrNS(string.intern(), string2.intern(), this);
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        SVGDOMImplementation sVGDOMImplementation = (SVGDOMImplementation)this.implementation;
        return sVGDOMImplementation.createElementNS(this, string, string2);
    }

    public Element getElementById(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        Element element = this.getDocumentElement();
        if (element == null) {
            return null;
        }
        return SVGOMDocument.getById(string, element);
    }

    protected static Element getById(String string, Node node) {
        Node node2;
        if (node.getNodeType() == 1 && (node2 = (Element)node).getAttributeNS(null, "id").equals(string)) {
            return node2;
        }
        for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Element element = SVGOMDocument.getById(string, node2);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
    }

    public StyleSheetList getStyleSheets() {
        throw new RuntimeException(" !!! Not implemented");
    }

    public AbstractView getDefaultView() {
        if (this.defaultView == null) {
            SVGDOMImplementation sVGDOMImplementation = (SVGDOMImplementation)this.implementation;
            this.defaultView = sVGDOMImplementation.createViewCSS(this);
        }
        return this.defaultView;
    }

    public void clearViewCSS() {
        this.defaultView = null;
        if (this.cssEngine != null) {
            this.cssEngine.dispose();
        }
        this.cssEngine = null;
    }

    public CSSStyleDeclaration getOverrideStyle(Element element, String string) {
        throw new RuntimeException(" !!! Not implemented");
    }

    protected Node newNode() {
        return new SVGOMDocument();
    }

    protected Node copyInto(Node node) {
        super.copyInto(node);
        SVGOMDocument sVGOMDocument = (SVGOMDocument)node;
        sVGOMDocument.localizableSupport = new LocalizableSupport(RESOURCES);
        sVGOMDocument.referrer = this.referrer;
        sVGOMDocument.url = this.url;
        return node;
    }

    protected Node deepCopyInto(Node node) {
        super.deepCopyInto(node);
        SVGOMDocument sVGOMDocument = (SVGOMDocument)node;
        sVGOMDocument.localizableSupport = new LocalizableSupport(RESOURCES);
        sVGOMDocument.referrer = this.referrer;
        sVGOMDocument.url = this.url;
        return node;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.localizableSupport = new LocalizableSupport(RESOURCES);
    }
}

