/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.configuration.AbstractConfiguration;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class DefaultConfigurationSerializer {
    private SAXTransformerFactory m_tfactory;
    private TransformerHandler m_handler;
    private OutputStream m_out;
    private Properties m_format = new Properties();
    private NamespaceSupport m_namespaceSupport = new NamespaceSupport();

    public DefaultConfigurationSerializer() {
        this.getTransformerFactory();
    }

    public void setIndent(boolean indent) {
        if (indent) {
            this.m_format.put("indent", "yes");
        } else {
            this.m_format.put("indent", "no");
        }
    }

    protected void setOutputStream(OutputStream out) {
        try {
            this.m_out = out;
            this.m_handler = this.getTransformerFactory().newTransformerHandler();
            this.m_format.put("method", "xml");
            this.m_handler.setResult(new StreamResult(out));
            this.m_handler.getTransformer().setOutputProperties(this.m_format);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    protected SAXTransformerFactory getTransformerFactory() {
        if (this.m_tfactory == null) {
            this.m_tfactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        }
        return this.m_tfactory;
    }

    protected void serialize(Configuration source) throws SAXException, ConfigurationException {
        this.m_namespaceSupport.reset();
        this.m_handler.startDocument();
        this.serializeElement(source);
        this.m_handler.endDocument();
    }

    protected void serializeElement(Configuration element) throws SAXException, ConfigurationException {
        this.m_namespaceSupport.pushContext();
        AttributesImpl attr = new AttributesImpl();
        String[] attrNames = element.getAttributeNames();
        if (null != attrNames) {
            int i = 0;
            while (i < attrNames.length) {
                attr.addAttribute("", attrNames[i], attrNames[i], "CDATA", element.getAttribute(attrNames[i], ""));
                ++i;
            }
        }
        String nsURI = element.getNamespace();
        String nsPrefix = "";
        if (element instanceof AbstractConfiguration) {
            nsPrefix = ((AbstractConfiguration)element).getPrefix();
        }
        boolean nsWasDeclared = false;
        String existingURI = this.m_namespaceSupport.getURI(nsPrefix);
        if (existingURI == null || !existingURI.equals(nsURI)) {
            nsWasDeclared = true;
            if (!nsPrefix.equals("") || !nsURI.equals("")) {
                if (nsPrefix.equals("")) {
                    attr.addAttribute("", "xmlns", "xmlns", "CDATA", nsURI);
                } else {
                    attr.addAttribute("", "xmlns:" + nsPrefix, "xmlns:" + nsPrefix, "CDATA", nsURI);
                }
            }
            this.m_handler.startPrefixMapping(nsPrefix, nsURI);
            this.m_namespaceSupport.declarePrefix(nsPrefix, nsURI);
        }
        String localName = element.getName();
        String qName = element.getName();
        qName = nsPrefix == null || nsPrefix.length() == 0 ? localName : nsPrefix + ":" + localName;
        this.m_handler.startElement(nsURI, localName, qName, attr);
        String value = element.getValue(null);
        if (null == value) {
            Configuration[] children = element.getChildren();
            int i = 0;
            while (i < children.length) {
                this.serializeElement(children[i]);
                ++i;
            }
        } else {
            this.m_handler.characters(value.toCharArray(), 0, value.length());
        }
        this.m_handler.endElement(nsURI, localName, qName);
        if (nsWasDeclared) {
            this.m_handler.endPrefixMapping(nsPrefix);
        }
        this.m_namespaceSupport.popContext();
    }

    public void serializeToFile(String filename, Configuration source) throws SAXException, IOException, ConfigurationException {
        this.serializeToFile(new File(filename), source);
    }

    public void serializeToFile(File file, Configuration source) throws SAXException, IOException, ConfigurationException {
        this.serialize(new FileOutputStream(file), source);
    }

    public void serialize(OutputStream outputStream, Configuration source) throws SAXException, IOException, ConfigurationException {
        DefaultConfigurationSerializer defaultConfigurationSerializer = this;
        synchronized (defaultConfigurationSerializer) {
            this.setOutputStream(outputStream);
            this.serialize(source);
        }
    }

    public void serialize(String uri, Configuration source) throws SAXException, IOException, ConfigurationException {
        this.serialize(new URL(uri).openConnection().getOutputStream(), source);
    }
}

