/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.VectorUnique;
import com.hp.hpl.deli.Vocabulary;
import com.hp.hpl.deli.Workspace;
import java.util.Vector;

public abstract class ProfileAttribute {
    protected int attributeRef;
    protected VectorUnique attributeValue;
    protected VectorUnique defaultAttributeValue;
    protected Workspace workspace;
    protected Vocabulary vocabulary;

    public ProfileAttribute(Workspace workspace, Vocabulary vocabulary) {
        this.workspace = workspace;
        this.vocabulary = vocabulary;
        this.attributeValue = new VectorUnique();
        this.defaultAttributeValue = new VectorUnique();
    }

    protected int getAttributeRef() {
        return this.attributeRef;
    }

    public Vector getValue() {
        return this.attributeValue.size() == 0 ? null : this.attributeValue;
    }

    public Vector getDefaultValue() {
        return this.defaultAttributeValue.size() == 0 ? null : this.defaultAttributeValue;
    }

    public String getComponent() {
        return this.vocabulary.getComponent(this.attributeRef);
    }

    public String getAttribute() {
        return this.vocabulary.getAttribute(this.attributeRef);
    }

    public String getResolution() {
        return this.vocabulary.getResolution(this.attributeRef);
    }

    public String getCollectionType() {
        return this.vocabulary.getCollectionType(this.attributeRef);
    }

    public String getType() {
        return this.vocabulary.getType(this.attributeRef);
    }

    public String getCcppUri() {
        return this.vocabulary.getCcppUri(this.attributeRef);
    }

    protected void set(int n, VectorUnique vectorUnique, boolean bl) {
        this.attributeRef = n;
        if (bl) {
            this.defaultAttributeValue = vectorUnique;
        } else {
            this.attributeValue = vectorUnique;
        }
    }

    protected abstract void set(ProfileAttribute var1);

    public Vector get() {
        return this.getValue() == null ? this.getDefaultValue() : this.getValue();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nAttribute:  " + this.getAttribute());
        stringBuffer.append("\nComponent:  " + this.getComponent());
        stringBuffer.append("\nResolution: " + this.getResolution());
        stringBuffer.append("\ncollectionType:" + this.getCollectionType());
        stringBuffer.append("\nType:       " + this.getType());
        stringBuffer.append("\nccppUri:    " + this.getCcppUri());
        if (this.workspace.printDefaults) {
            stringBuffer.append("\nValue:      " + this.getValue());
            stringBuffer.append("\nDefaultVal: " + this.getDefaultValue() + "\n");
        } else {
            stringBuffer.append("\nResolvedVal:" + this.get() + "\n");
        }
        return stringBuffer.toString();
    }
}

