/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class AxisUsedRecord
extends Record {
    public static final short sid = 4166;
    private short field_1_numAxis;

    public AxisUsedRecord() {
    }

    public AxisUsedRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public AxisUsedRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 4166) {
            throw new RecordFormatException("Not a AxisUsed record");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_numAxis = LittleEndian.getShort(data, 0 + offset);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[AxisUsed]\n");
        buffer.append("    .numAxis              = ").append("0x").append(HexDump.toHex(this.getNumAxis())).append(" (").append(this.getNumAxis()).append(" )\n");
        buffer.append("[/AxisUsed]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)4166);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset, this.field_1_numAxis);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 4166;
    }

    public short getNumAxis() {
        return this.field_1_numAxis;
    }

    public void setNumAxis(short field_1_numAxis) {
        this.field_1_numAxis = field_1_numAxis;
    }

    static {
        sid = (short)4166;
    }
}

