/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.Action;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;

public class LangSelect
extends AbstractLoggable
implements Action,
Configurable,
ThreadSafe {
    private static final String DEFAULT_LANG = "en";
    private static final String PARAM_LANG = "lang";
    private boolean storeInRequest = false;
    private boolean storeInSession = false;
    private boolean createSession = false;
    private boolean storeInCookie = false;

    public void configure(Configuration conf) throws ConfigurationException {
        this.getLogger().warn("LangSelect action is deprecated. Please use LocaleAction");
        if (conf != null) {
            Configuration child = conf.getChild("store-in-request");
            this.storeInRequest = child.getValueAsBoolean(false);
            child = conf.getChild("create-session");
            this.createSession = child.getValueAsBoolean(false);
            child = conf.getChild("store-in-session");
            this.storeInSession = child.getValueAsBoolean(false);
            child = conf.getChild("store-in-cookie");
            this.storeInCookie = child.getValueAsBoolean(false);
        }
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters par) throws Exception {
        String lang;
        if (objectModel.containsKey(PARAM_LANG)) {
            lang = (String)objectModel.get(PARAM_LANG);
        } else {
            lang = LangSelect.getLang(objectModel, par);
            objectModel.put(PARAM_LANG, lang);
        }
        Request request = ObjectModelHelper.getRequest(objectModel);
        request.getSession(this.createSession);
        if (this.storeInSession || this.storeInCookie) {
            this.storeLang(objectModel, lang);
        }
        HashMap<String, String> m = new HashMap<String, String>(1);
        m.put(PARAM_LANG, lang);
        return m;
    }

    public static String getLang(Map objectModel, Parameters par) {
        Cookie[] cookies;
        Object session_lang;
        Session session;
        ArrayList<String> langs_avail = new ArrayList<String>();
        ArrayList<String> langs_user = new ArrayList<String>();
        Iterator params = par.getParameterNames();
        while (params.hasNext()) {
            String paramname = (String)params.next();
            if (!paramname.startsWith("available_lang")) continue;
            langs_avail.add(par.getParameter(paramname, null));
        }
        String def_lang = par.getParameter("default_lang", DEFAULT_LANG);
        Request request = ObjectModelHelper.getRequest(objectModel);
        String lang = null;
        lang = request.getParameter(PARAM_LANG);
        if (lang == null && (session = request.getSession(false)) != null && (session_lang = session.getAttribute(PARAM_LANG)) != null) {
            lang = session_lang.toString();
        }
        if (lang == null && (cookies = request.getCookies()) != null) {
            int i = 0;
            while (i < cookies.length) {
                Cookie cookie = cookies[i];
                if (cookie.getName().equals(PARAM_LANG)) {
                    lang = cookie.getValue();
                }
                ++i;
            }
        }
        if (lang == null) {
            Enumeration locales = request.getLocales();
            while (locales.hasMoreElements()) {
                Locale locale = (Locale)locales.nextElement();
                langs_user.add(locale.getLanguage());
            }
            boolean match = false;
            int i = 0;
            while (i < langs_user.size() && !match) {
                int j = 0;
                while (j < langs_avail.size()) {
                    if (((String)langs_user.get(i)).equals((String)langs_avail.get(j))) {
                        match = true;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            lang = match ? (String)langs_user.get(i - 1) : def_lang;
        }
        return lang;
    }

    public void storeLang(Map objectModel, String lang) throws Exception {
        if (lang == null) {
            lang = DEFAULT_LANG;
        }
        Request request = ObjectModelHelper.getRequest(objectModel);
        if (this.storeInRequest) {
            request.setAttribute(PARAM_LANG, lang);
        }
        if (this.storeInSession) {
            Session session = request.getSession(false);
            if (session != null) {
                Session session2 = session;
                synchronized (session2) {
                    session.setAttribute(PARAM_LANG, lang);
                }
            } else {
                throw new Exception("LangSelect: session is not available.");
            }
        }
        if (this.storeInCookie) {
            Response response = ObjectModelHelper.getResponse(objectModel);
            Cookie langCookie = response.createCookie(PARAM_LANG, lang);
            response.addCookie(langCookie);
        }
    }
}

