/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.components.modules.input.AbstractMetaModule;

public class DigestMetaModule
extends AbstractMetaModule {
    private String defaultAlgorithm = "SHA";
    private String defaultProvider = null;
    private String defaultSalt = "salt";
    private boolean defaultEncode = false;

    public void configure(Configuration config2) throws ConfigurationException {
        this.inputConf = config2.getChild("input-module");
        this.defaultAlgorithm = this.inputConf.getAttribute("algorithm", this.defaultAlgorithm);
        this.defaultProvider = this.inputConf.getAttribute("provider", this.defaultProvider);
        this.defaultSalt = this.inputConf.getAttribute("salt", this.defaultSalt);
        this.defaultEncode = this.inputConf.getAttributeAsBoolean("encode", this.defaultEncode);
    }

    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        block11: {
            if (!this.initialized.booleanValue()) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Uninitialized Component! FAILING");
                }
                return null;
            }
            if (this.defaultInput == null) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("No input module given. FAILING");
                }
                return null;
            }
            Configuration inputConfig = null;
            String inputName = null;
            if (modeConf != null && (inputName = modeConf.getChild("input-module").getAttribute("name", null)) != null) {
                inputConfig = modeConf.getChild("input-module");
            }
            String algorithm = modeConf.getAttribute("algorithm", this.defaultAlgorithm);
            String provider = modeConf.getAttribute("provider", this.defaultProvider);
            String salt = modeConf.getAttribute("salt", this.defaultSalt);
            boolean encode = modeConf.getAttributeAsBoolean("encode", this.defaultEncode);
            Object result = null;
            Object value = this.getValue(name, objectModel, this.input, this.defaultInput, this.inputConf, null, inputName, inputConfig);
            if (value != null) {
                try {
                    MessageDigest md = provider == null ? MessageDigest.getInstance(algorithm) : MessageDigest.getInstance(algorithm, provider);
                    md.update((salt + (value instanceof String ? (String)value : value.toString())).getBytes());
                    if (encode) {
                        return URLEncoder.encode(new String(md.digest()));
                    }
                    return md.digest();
                }
                catch (NoSuchAlgorithmException nsae) {
                    if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("A problem occurred acquiring digest algorithm '" + algorithm + (provider == null ? "" : "' from '" + provider) + "': " + nsae.getMessage());
                    }
                }
                catch (NoSuchProviderException nspe) {
                    if (!this.getLogger().isWarnEnabled()) break block11;
                    this.getLogger().warn("A problem occurred acquiring digest algorithm '" + algorithm + (provider == null ? "" : "' from '" + provider) + "': " + nspe.getMessage());
                }
            }
        }
        return null;
    }

    public Iterator getAttributeNames(Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (!this.initialized.booleanValue()) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Uninitialized Component! FAILING");
            }
            return null;
        }
        if (this.defaultInput == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("No input module given. FAILING");
            }
            return null;
        }
        Configuration inputConfig = null;
        String inputName = null;
        if (modeConf != null && (inputName = modeConf.getChild("input-module").getAttribute("name", null)) != null) {
            inputConfig = modeConf.getChild("input-module");
        }
        Iterator names = this.getNames(objectModel, this.input, this.defaultInput, this.inputConf, null, inputName, inputConfig);
        return names;
    }

    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        Object[] result;
        block11: {
            if (!this.initialized.booleanValue()) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Uninitialized Component! FAILING");
                }
                return null;
            }
            if (this.defaultInput == null) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("No input module given. FAILING");
                }
                return null;
            }
            Configuration inputConfig = null;
            String inputName = null;
            if (modeConf != null && (inputName = modeConf.getChild("input-module").getAttribute("name", null)) != null) {
                inputConfig = modeConf.getChild("input-module");
            }
            String algorithm = modeConf.getAttribute("algorithm", this.defaultAlgorithm);
            String provider = modeConf.getAttribute("provider", this.defaultProvider);
            String salt = modeConf.getAttribute("salt", this.defaultSalt);
            boolean encode = modeConf.getAttributeAsBoolean("encode", this.defaultEncode);
            Object[] values = this.getValues(name, objectModel, this.input, this.defaultInput, this.inputConf, null, inputName, inputConfig);
            result = null;
            if (values != null) {
                try {
                    MessageDigest md = provider == null ? MessageDigest.getInstance(algorithm) : MessageDigest.getInstance(algorithm, provider);
                    result = new Object[values.length];
                    int i = 0;
                    while (i < values.length) {
                        md.update((salt + (values[i] instanceof String ? (String)values[i] : values[i].toString())).getBytes());
                        result[i] = encode ? URLEncoder.encode(new String(md.digest())) : (Object)md.digest();
                        ++i;
                    }
                    return result;
                }
                catch (NoSuchAlgorithmException nsae) {
                    if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("A problem occurred acquiring digest algorithm '" + algorithm + (provider == null ? "" : "' from '" + provider) + "': " + nsae.getMessage());
                    }
                }
                catch (NoSuchProviderException nspe) {
                    if (!this.getLogger().isWarnEnabled()) break block11;
                    this.getLogger().warn("A problem occurred acquiring digest algorithm '" + algorithm + (provider == null ? "" : "' from '" + provider) + "': " + nspe.getMessage());
                }
            }
        }
        return result;
    }
}

