/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.profiler;

import java.util.Arrays;
import org.apache.cocoon.components.profiler.ProfilerData;

public class ProfilerResult {
    private String uri;
    private String[] roles;
    private String[] sources;
    private int count;
    private long[] totalTime;
    private long[][] latestTimes;
    private int latestCurrent;

    public ProfilerResult(String uri, int latestResultsCount) {
        this.uri = uri;
        if (latestResultsCount > 0) {
            this.latestTimes = new long[latestResultsCount][];
        }
    }

    public void addData(ProfilerData data) {
        ProfilerData.Entry[] entries = data.getEntries();
        ProfilerResult profilerResult = this;
        synchronized (profilerResult) {
            int i;
            if (this.totalTime == null || this.totalTime.length != entries.length) {
                this.totalTime = new long[entries.length];
                this.roles = new String[entries.length];
                this.sources = new String[entries.length];
                i = 0;
                while (i < entries.length) {
                    this.roles[i] = entries[i].role;
                    if (this.roles[i] == null) {
                        this.roles[i] = entries[i].component.getClass().getName();
                    }
                    this.sources[i] = entries[i].source;
                    ++i;
                }
                if (this.latestTimes != null) {
                    Arrays.fill((Object[])this.latestTimes, 0, this.latestTimes.length, null);
                }
                this.latestCurrent = 0;
                this.count = 0;
            }
            i = 0;
            while (i < entries.length - 1) {
                entries[i].time -= entries[i + 1].time;
                ++i;
            }
            long[] latest = new long[entries.length];
            int i2 = 0;
            while (i2 < entries.length) {
                int n = i2;
                latest[i2] = entries[i2].time;
                this.totalTime[n] = this.totalTime[n] + latest[i2];
                ++i2;
            }
            if (this.latestTimes != null) {
                this.latestTimes[this.latestCurrent++] = latest;
                if (this.latestCurrent >= this.latestTimes.length) {
                    this.latestCurrent = 0;
                }
            }
            ++this.count;
        }
    }

    public String getURI() {
        return this.uri;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public String[] getSources() {
        return this.sources;
    }

    public int getCount() {
        return this.count;
    }

    public long[] getTotalTime() {
        return this.totalTime;
    }

    public long[][] getLastTimes() {
        return this.latestTimes;
    }
}

