/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.acting.LocaleAction;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.i18n.I18nUtils;
import org.apache.cocoon.i18n.XMLResourceBundle;
import org.apache.cocoon.i18n.XMLResourceBundleFactory;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class I18nTransformer
extends AbstractTransformer
implements Composable,
Configurable,
Disposable {
    public static final String I18N_NAMESPACE_URI = "http://apache.org/cocoon/i18n/2.0";
    public static final String I18N_TEXT_ELEMENT = "text";
    public static final String I18N_TRANSLATE_ELEMENT = "translate";
    public static final String I18N_PARAM_ELEMENT = "param";
    public static final String I18N_DATE_ELEMENT = "date";
    public static final String I18N_DATE_TIME_ELEMENT = "date-time";
    public static final String I18N_TIME_ELEMENT = "time";
    public static final String I18N_NUMBER_ELEMENT = "number";
    public static final String I18N_CURRENCY_ELEMENT = "currency";
    public static final String I18N_PERCENT_ELEMENT = "percent";
    public static final String I18N_INT_CURRENCY_ELEMENT = "int-currency";
    public static final String I18N_CURRENCY_NO_UNIT_ELEMENT = "currency-no-unit";
    public static final String I18N_INT_CURRENCY_NO_UNIT_ELEMENT = "int-currency-no-unit";
    public static final String I18N_KEY_ATTRIBUTE = "key";
    public static final String I18N_ATTR_ATTRIBUTE = "attr";
    public static final String I18N_SRC_PATTERN_ATTRIBUTE = "src-pattern";
    public static final String I18N_PATTERN_ATTRIBUTE = "pattern";
    public static final String I18N_LOCALE_ATTRIBUTE = "locale";
    public static final String I18N_SRC_LOCALE_ATTRIBUTE = "src-locale";
    public static final String I18N_VALUE_ATTRIBUTE = "value";
    public static final String I18N_TYPE_ATTRIBUTE = "type";
    public static final String I18N_LOCALE = "locale";
    public static final String I18N_CATALOGUE_NAME = "catalogue-name";
    public static final String I18N_CATALOGUE_LOCATION = "catalogue-location";
    public static final String I18N_UNTRANSLATED = "untranslated-text";
    public static final String I18N_CACHE_STARTUP = "cache-at-startup";
    public static final String I18N_CATALOGUE_PREFIX = "/catalogue/message";
    private static final String FILE = "file:";
    public static final String I18N_FRACTION_DIGITS_ATTRIBUTE = "fraction-digits";
    private static final int STATE_OUTSIDE = 0;
    private static final int STATE_INSIDE_TEXT = 1;
    private static final int STATE_INSIDE_PARAM = 2;
    private static final int STATE_INSIDE_TRANSLATE = 3;
    private static final int STATE_INSIDE_TRANSLATE_TEXT = 4;
    private static final int STATE_TRANSLATE_KEY = 5;
    private static final int STATE_TRANSLATE_TEXT_KEY = 6;
    private static final int STATE_INSIDE_DATE = 7;
    private static final int STATE_INSIDE_DATE_TIME = 8;
    private static final int STATE_INSIDE_TIME = 9;
    private static final int STATE_INSIDE_NUMBER = 10;
    private static final Set dateTypes;
    private static final Set numberTypes;
    private static final Map datePatterns;
    private ComponentManager manager;
    private int current_state;
    private int prev_state;
    private StringBuffer strBuffer;
    private String current_key;
    private String translated_text;
    private String substitute_text;
    private String param_value;
    private ArrayList indexedParams;
    private MessageFormat formatter;
    private Locale locale;
    private HashMap formattingParams;
    private XMLResourceBundle dictionary;
    private XMLResourceBundleFactory factory = new XMLResourceBundleFactory();
    private String catalogueName;
    private String catalogueLocation;
    private String untranslated;
    private boolean cacheAtStartup;
    private String globalUntranslated;

    public Locale getLocale() {
        return this.locale;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        if (conf != null) {
            Configuration child = conf.getChild(I18N_CATALOGUE_NAME);
            this.catalogueName = child.getValue(null);
            this.debug("Default catalogue name is " + this.catalogueName);
            child = conf.getChild(I18N_CATALOGUE_LOCATION);
            this.catalogueLocation = child.getValue(null);
            this.debug("Default catalogue location is " + this.catalogueLocation);
            if (this.catalogueName == null || this.catalogueLocation == null) {
                throw new ConfigurationException("I18nTransformer requires the name and location of the message catalogues");
            }
            child = conf.getChild(I18N_UNTRANSLATED);
            this.untranslated = child.getValue(null);
            this.debug("Default untranslated text is '" + this.untranslated + "'");
            child = conf.getChild(I18N_CACHE_STARTUP);
            this.cacheAtStartup = child.getValueAsBoolean(false);
            this.debug((this.cacheAtStartup ? "will" : "won't") + " cache messages during startup, by default");
            this.factory.setLogger(this.getLogger());
        }
    }

    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        try {
            String localCatLocation = null;
            String localCatName = null;
            String localUntranslated = null;
            String lc = null;
            if (parameters != null) {
                localCatLocation = parameters.getParameter(I18N_CATALOGUE_LOCATION, null);
                localCatName = parameters.getParameter(I18N_CATALOGUE_NAME, null);
                localUntranslated = parameters.getParameter(I18N_UNTRANSLATED, null);
                lc = parameters.getParameter("locale", null);
            }
            if (localUntranslated != null) {
                this.globalUntranslated = this.untranslated;
                this.untranslated = localUntranslated;
            }
            this._setup(resolver, localCatLocation == null ? this.catalogueLocation : localCatLocation);
            if (lc == null) {
                lc = LocaleAction.getLocaleAttribute(objectModel);
            }
            Locale locale = I18nUtils.parseLocale(lc);
            this.debug("using locale " + locale.toString());
            this.dictionary = (XMLResourceBundle)this.factory.select(localCatName == null ? this.catalogueName : localCatName, locale);
            this.debug("selected dictionary " + this.dictionary);
            this.locale = locale;
            this.current_state = 0;
            this.prev_state = 0;
            this.current_key = null;
            this.translated_text = null;
            this.substitute_text = null;
            this.param_value = null;
            this.indexedParams = new ArrayList();
            this.formattingParams = null;
            this.strBuffer = null;
            this.formatter = new MessageFormat("");
            this.formatter.setLocale(locale);
        }
        catch (Exception e) {
            this.debug("exception generated, leaving unconfigured");
            throw new ProcessingException(e.getMessage(), e);
        }
    }

    private void _setup(SourceResolver resolver, String location) throws Exception {
        DefaultConfiguration configuration = new DefaultConfiguration("name", "location");
        DefaultConfiguration cacheConf = new DefaultConfiguration(I18N_CACHE_STARTUP, "location");
        cacheConf.setValue(new Boolean(this.cacheAtStartup).toString());
        configuration.addChild((Configuration)cacheConf);
        DefaultConfiguration dirConf = new DefaultConfiguration(I18N_CATALOGUE_LOCATION, "location");
        this.debug("catalog location:" + location);
        Source source = resolver.resolve(location);
        try {
            String systemId = source.getSystemId();
            if (!systemId.startsWith(FILE)) {
                throw new ResourceNotFoundException(systemId + " does not denote a directory");
            }
            this.debug("catalog directory:" + systemId);
            dirConf.setValue(systemId);
            configuration.addChild((Configuration)dirConf);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            source.recycle();
            throw throwable;
        }
        source.recycle();
        this.factory.configure((Configuration)configuration);
        this.debug("configured");
    }

    public void compose(ComponentManager manager) {
        this.manager = manager;
        this.factory.compose(manager);
    }

    public void startElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        if (I18N_NAMESPACE_URI.equals(uri)) {
            this.debug("Starting i18n element: " + name);
            if (this.strBuffer != null) {
                this.i18nCharacters(this.strBuffer.toString());
                this.strBuffer = null;
            }
            this.startI18NElement(name, attr);
            return;
        }
        super.startElement(uri, name, raw, this.translateAttributes(name, attr));
    }

    public void endElement(String uri, String name, String raw) throws SAXException {
        if (I18N_NAMESPACE_URI.equals(uri)) {
            if (this.strBuffer != null) {
                this.i18nCharacters(this.strBuffer.toString());
                this.strBuffer = null;
            }
            this.endI18NElement(name);
            return;
        }
        super.endElement(uri, name, raw);
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        if (this.current_state != 0) {
            if (this.strBuffer == null) {
                this.strBuffer = new StringBuffer();
            }
            this.strBuffer.append(ch, start, len);
            return;
        }
        super.characters(ch, start, len);
    }

    private void startI18NElement(String name, Attributes attr) throws SAXException {
        this.debug("Start i18n element: " + name);
        if (I18N_TEXT_ELEMENT.equals(name)) {
            if (this.current_state != 0 && this.current_state != 2 && this.current_state != 3) {
                throw new SAXException(this.getClass().getName() + ": nested i18n:text elements are not allowed." + " Current state: " + this.current_state);
            }
            this.prev_state = this.current_state;
            this.current_state = 1;
            this.current_key = attr.getValue(I18N_NAMESPACE_URI, I18N_KEY_ATTRIBUTE);
        } else if (I18N_TRANSLATE_ELEMENT.equals(name)) {
            if (this.current_state != 0) {
                throw new SAXException(this.getClass().getName() + ": i18n:translate element must be used " + "outside of other i18n elements. Current state: " + this.current_state);
            }
            this.current_state = 3;
        } else if (I18N_PARAM_ELEMENT.equals(name)) {
            if (this.current_state != 3) {
                throw new SAXException(this.getClass().getName() + ": i18n:param element can be used only inside " + "i18n:translate element. Current state: " + this.current_state);
            }
            this.setFormattingParams(attr);
            this.current_state = 2;
        } else if (I18N_DATE_ELEMENT.equals(name)) {
            if (this.current_state != 0) {
                throw new SAXException(this.getClass().getName() + ": i18n:date elements are not allowed " + "inside of other i18n elements.");
            }
            this.setFormattingParams(attr);
            this.current_state = 7;
        } else if (I18N_DATE_TIME_ELEMENT.equals(name)) {
            if (this.current_state != 0) {
                throw new SAXException(this.getClass().getName() + ": i18n:date-time elements are not allowed " + "inside of other i18n elements.");
            }
            this.setFormattingParams(attr);
            this.current_state = 8;
        } else if (I18N_TIME_ELEMENT.equals(name)) {
            if (this.current_state != 0) {
                throw new SAXException(this.getClass().getName() + ": i18n:date elements are not allowed " + "inside of other i18n elements.");
            }
            this.setFormattingParams(attr);
            this.current_state = 9;
        } else if (I18N_NUMBER_ELEMENT.equals(name)) {
            if (this.current_state != 0) {
                throw new SAXException(this.getClass().getName() + ": i18n:number elements are not allowed " + "inside of other i18n elements.");
            }
            this.setFormattingParams(attr);
            this.current_state = 10;
        }
    }

    private void setFormattingParams(Attributes attr) throws SAXException {
        this.formattingParams = new HashMap(3);
        String attr_value = attr.getValue(I18N_SRC_PATTERN_ATTRIBUTE);
        if (attr_value != null) {
            this.formattingParams.put(I18N_SRC_PATTERN_ATTRIBUTE, attr_value);
        }
        if ((attr_value = attr.getValue(I18N_PATTERN_ATTRIBUTE)) != null) {
            this.formattingParams.put(I18N_PATTERN_ATTRIBUTE, attr_value);
        }
        if ((attr_value = attr.getValue(I18N_VALUE_ATTRIBUTE)) != null) {
            this.formattingParams.put(I18N_VALUE_ATTRIBUTE, attr_value);
        }
        if ((attr_value = attr.getValue("locale")) != null) {
            this.formattingParams.put("locale", attr_value);
        }
        if ((attr_value = attr.getValue(I18N_SRC_LOCALE_ATTRIBUTE)) != null) {
            this.formattingParams.put(I18N_SRC_LOCALE_ATTRIBUTE, attr_value);
        }
        if ((attr_value = attr.getValue(I18N_TYPE_ATTRIBUTE)) != null) {
            this.formattingParams.put(I18N_TYPE_ATTRIBUTE, attr_value);
        }
        if ((attr_value = attr.getValue(I18N_FRACTION_DIGITS_ATTRIBUTE)) != null) {
            this.formattingParams.put(I18N_FRACTION_DIGITS_ATTRIBUTE, attr_value);
        }
    }

    private void endI18NElement(String name) throws SAXException {
        this.debug("End i18n element: " + name);
        switch (this.current_state) {
            case 1: {
                this.endTextElement();
                break;
            }
            case 3: {
                this.endTranslateElement();
                break;
            }
            case 2: {
                this.endParamElement();
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                this.endDate_TimeElement();
                break;
            }
            case 10: {
                this.endNumberElement();
            }
        }
    }

    private void i18nCharacters(String textValue) throws SAXException {
        if ((textValue = textValue.trim()) == null || textValue.length() == 0) {
            return;
        }
        this.debug("i18n message text = '" + textValue + "'");
        switch (this.current_state) {
            case 1: {
                if (this.current_key != null) {
                    this.translated_text = this.getString(this.current_key, this.untranslated);
                    if (this.translated_text == null) {
                        this.translated_text = textValue;
                    }
                    this.current_key = null;
                    break;
                }
                this.translated_text = this.getString(textValue, this.untranslated == null ? textValue : this.untranslated);
                break;
            }
            case 3: {
                if (this.substitute_text != null) break;
                this.substitute_text = textValue;
                break;
            }
            case 2: {
                if (this.param_value != null) break;
                this.param_value = textValue;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                if (this.formattingParams.get(I18N_VALUE_ATTRIBUTE) != null) break;
                this.formattingParams.put(I18N_VALUE_ATTRIBUTE, textValue);
                break;
            }
            default: {
                throw new IllegalStateException(this.getClass().getName() + " developer's fault");
            }
        }
    }

    private Attributes translateAttributes(String name, Attributes attr) throws SAXException {
        if (attr == null) {
            return attr;
        }
        AttributesImpl temp_attr = new AttributesImpl(attr);
        int i18n_attr_index = temp_attr.getIndex(I18N_NAMESPACE_URI, I18N_ATTR_ATTRIBUTE);
        if (i18n_attr_index != -1) {
            StringTokenizer st = new StringTokenizer(temp_attr.getValue(i18n_attr_index));
            temp_attr.removeAttribute(i18n_attr_index);
            while (st.hasMoreElements()) {
                String attr_name = st.nextToken();
                int attr_index = temp_attr.getIndex(attr_name);
                if (attr_index != -1) {
                    String text2translate = temp_attr.getValue(attr_index);
                    String result = this.getString(text2translate, this.untranslated == null ? text2translate : this.untranslated);
                    if (result != null) {
                        temp_attr.setValue(attr_index, result);
                        continue;
                    }
                    this.getLogger().warn("translation not found for attribute " + attr_name + " in element: " + name);
                    continue;
                }
                this.getLogger().warn("i18n attribute '" + attr_name + "' not found in element: " + name);
            }
            return temp_attr;
        }
        return attr;
    }

    private void endTextElement() throws SAXException {
        this.debug("End text element, translated_text: " + this.translated_text);
        switch (this.prev_state) {
            case 0: {
                if (this.translated_text != null) {
                    this.contentHandler.characters(this.translated_text.toCharArray(), 0, this.translated_text.length());
                    break;
                }
                this.debug("--- Translation not found! ---");
                break;
            }
            case 3: {
                this.substitute_text = this.translated_text;
                break;
            }
            case 2: {
                this.param_value = this.translated_text;
            }
        }
        this.translated_text = null;
        this.current_state = this.prev_state;
        this.prev_state = 0;
    }

    private void endParamElement() throws SAXException {
        this.debug("Substitution param: " + this.param_value);
        String paramType = (String)this.formattingParams.get(I18N_TYPE_ATTRIBUTE);
        if (paramType != null) {
            this.debug("Param type: " + paramType);
            if (this.formattingParams.get(I18N_VALUE_ATTRIBUTE) == null && this.param_value != null) {
                this.debug("Put param value: " + this.param_value);
                this.formattingParams.put(I18N_VALUE_ATTRIBUTE, this.param_value);
            }
            if (dateTypes.contains(paramType)) {
                this.debug("Formatting date_time param: " + this.formattingParams);
                this.param_value = this.formatDate_Time(this.formattingParams);
            } else if (numberTypes.contains(paramType)) {
                this.debug("Formatting number param: " + this.formattingParams);
                this.param_value = this.formatNumber(this.formattingParams);
            }
        }
        this.debug("Added substitution param: " + this.param_value);
        this.indexedParams.add(this.param_value);
        this.param_value = null;
        this.current_state = 3;
    }

    private void endTranslateElement() throws SAXException {
        String result;
        if (this.substitute_text == null) {
            return;
        }
        if (this.indexedParams.size() > 0 && this.substitute_text.length() > 0) {
            this.debug("Text for susbtitution: " + this.substitute_text);
            result = MessageFormat.format(this.substitute_text, this.indexedParams.toArray());
            this.debug("Result of susbtitution: " + result);
        } else {
            result = this.substitute_text;
        }
        this.contentHandler.characters(result.toCharArray(), 0, result.length());
        this.indexedParams.clear();
        this.substitute_text = null;
        this.current_state = 0;
    }

    private void endDate_TimeElement() throws SAXException {
        String result = this.formatDate_Time(this.formattingParams);
        this.contentHandler.characters(result.toCharArray(), 0, result.length());
        this.current_state = 0;
    }

    private Locale getLocale(Map params, String attribute) {
        String lc = (String)params.get(attribute);
        return I18nUtils.parseLocale(lc, this.locale);
    }

    private String formatDate_Time(Map params) throws SAXException {
        Integer patternValue;
        if (params == null) {
            throw new IllegalArgumentException("Nothing to format");
        }
        SimpleDateFormat to_fmt = null;
        SimpleDateFormat from_fmt = null;
        int srcStyle = 2;
        int style = 2;
        boolean realPattern = false;
        boolean realSrcPattern = false;
        Locale srcLoc = this.getLocale(params, I18N_SRC_LOCALE_ATTRIBUTE);
        Locale loc = this.getLocale(params, "locale");
        String srcPattern = (String)params.get(I18N_SRC_PATTERN_ATTRIBUTE);
        String pattern = (String)params.get(I18N_PATTERN_ATTRIBUTE);
        String value = (String)params.get(I18N_VALUE_ATTRIBUTE);
        if (srcPattern != null) {
            patternValue = (Integer)datePatterns.get(srcPattern.toUpperCase());
            if (patternValue != null) {
                srcStyle = patternValue;
            } else {
                realSrcPattern = true;
            }
        }
        if (pattern != null) {
            patternValue = (Integer)datePatterns.get(pattern.toUpperCase());
            if (patternValue != null) {
                style = patternValue;
            } else {
                realPattern = true;
            }
        }
        String paramType = (String)this.formattingParams.get(I18N_TYPE_ATTRIBUTE);
        if (this.current_state == 7 || I18N_DATE_ELEMENT.equals(paramType)) {
            to_fmt = (SimpleDateFormat)DateFormat.getDateInstance(style, loc);
            from_fmt = (SimpleDateFormat)DateFormat.getDateInstance(srcStyle, srcLoc);
        } else if (this.current_state == 8 || I18N_DATE_TIME_ELEMENT.equals(paramType)) {
            to_fmt = (SimpleDateFormat)DateFormat.getDateTimeInstance(style, style, loc);
            from_fmt = (SimpleDateFormat)DateFormat.getDateTimeInstance(srcStyle, srcStyle, srcLoc);
        } else {
            to_fmt = (SimpleDateFormat)DateFormat.getTimeInstance(style, loc);
            from_fmt = (SimpleDateFormat)DateFormat.getTimeInstance(srcStyle, srcLoc);
        }
        Date dateValue = null;
        if (realSrcPattern) {
            from_fmt.applyPattern(srcPattern);
        }
        if (realPattern) {
            to_fmt.applyPattern(pattern);
        }
        if (value == null) {
            dateValue = new Date();
        } else {
            try {
                dateValue = from_fmt.parse(value);
            }
            catch (ParseException pe) {
                throw new SAXException(this.getClass().getName() + "i18n:date - parsing error.", pe);
            }
        }
        this.debug("### Formatting date: " + dateValue + " with localized pattern " + to_fmt.toLocalizedPattern() + " for locale: " + this.locale);
        return to_fmt.format(dateValue);
    }

    private void endNumberElement() throws SAXException {
        String result = this.formatNumber(this.formattingParams);
        this.contentHandler.characters(result.toCharArray(), 0, result.length());
        this.current_state = 0;
    }

    private String formatNumber(Map params) throws SAXException {
        if (params == null) {
            throw new SAXException(this.getClass().getName() + ": i18n:number - error in element attributes.");
        }
        String srcPattern = (String)params.get(I18N_SRC_PATTERN_ATTRIBUTE);
        String pattern = (String)params.get(I18N_PATTERN_ATTRIBUTE);
        String value = (String)params.get(I18N_VALUE_ATTRIBUTE);
        if (value == null) {
            return "";
        }
        String type = (String)params.get(I18N_TYPE_ATTRIBUTE);
        int fractionDigits = -1;
        try {
            fractionDigits = Integer.parseInt((String)params.get(I18N_FRACTION_DIGITS_ATTRIBUTE));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        Number numberValue = null;
        Locale loc = this.getLocale(params, "locale");
        Locale srcLoc = this.getLocale(params, I18N_SRC_LOCALE_ATTRIBUTE);
        DecimalFormat from_fmt = (DecimalFormat)NumberFormat.getInstance(srcLoc);
        int int_currency = 0;
        if (srcPattern != null) {
            from_fmt.applyPattern(srcPattern);
        }
        DecimalFormat to_fmt = null;
        char dec = from_fmt.getDecimalFormatSymbols().getDecimalSeparator();
        int decAt = 0;
        boolean appendDec = false;
        if (type == null || type.equals(I18N_NUMBER_ELEMENT)) {
            to_fmt = (DecimalFormat)NumberFormat.getInstance(loc);
            to_fmt.setMaximumFractionDigits(309);
            int i = value.length() - 1;
            while (i >= 0 && value.charAt(i) != dec) {
                --i;
                ++decAt;
            }
            if (decAt < value.length()) {
                to_fmt.setMinimumFractionDigits(decAt);
            }
            decAt = 0;
            int i2 = 0;
            while (i2 < value.length() && value.charAt(i2) != dec) {
                if (Character.isDigit(value.charAt(i2))) {
                    ++decAt;
                }
                ++i2;
            }
            to_fmt.setMinimumIntegerDigits(decAt);
            if (value.charAt(value.length() - 1) == dec) {
                appendDec = true;
            }
        } else if (type.equals(I18N_CURRENCY_ELEMENT)) {
            to_fmt = (DecimalFormat)NumberFormat.getCurrencyInstance(loc);
        } else if (type.equals(I18N_INT_CURRENCY_ELEMENT)) {
            to_fmt = (DecimalFormat)NumberFormat.getCurrencyInstance(loc);
            int_currency = 1;
            int i = 0;
            while (i < to_fmt.getMaximumFractionDigits()) {
                int_currency *= 10;
                ++i;
            }
        } else if (type.equals(I18N_CURRENCY_NO_UNIT_ELEMENT)) {
            DecimalFormat tmp = (DecimalFormat)NumberFormat.getCurrencyInstance(loc);
            to_fmt = (DecimalFormat)NumberFormat.getInstance(loc);
            to_fmt.setMinimumFractionDigits(tmp.getMinimumFractionDigits());
            to_fmt.setMaximumFractionDigits(tmp.getMaximumFractionDigits());
        } else if (type.equals(I18N_INT_CURRENCY_NO_UNIT_ELEMENT)) {
            DecimalFormat tmp = (DecimalFormat)NumberFormat.getCurrencyInstance(loc);
            int_currency = 1;
            int i = 0;
            while (i < tmp.getMaximumFractionDigits()) {
                int_currency *= 10;
                ++i;
            }
            to_fmt = (DecimalFormat)NumberFormat.getInstance(loc);
            to_fmt.setMinimumFractionDigits(tmp.getMinimumFractionDigits());
            to_fmt.setMaximumFractionDigits(tmp.getMaximumFractionDigits());
        } else if (type.equals(I18N_PERCENT_ELEMENT)) {
            to_fmt = (DecimalFormat)NumberFormat.getPercentInstance(loc);
        } else {
            throw new SAXException("&lt;i18n:number>: unknown type: " + type);
        }
        if (fractionDigits > -1) {
            to_fmt.setMinimumFractionDigits(fractionDigits);
            to_fmt.setMaximumFractionDigits(fractionDigits);
        }
        if (pattern != null) {
            to_fmt.applyPattern(pattern);
        }
        if (value == null) {
            numberValue = new Long(0L);
        } else {
            try {
                numberValue = from_fmt.parse(value);
                if (int_currency > 0) {
                    numberValue = new Double(numberValue.doubleValue() / (double)int_currency);
                }
            }
            catch (ParseException pe) {
                throw new SAXException(this.getClass().getName() + "i18n:number - parsing error.", pe);
            }
        }
        String result = to_fmt.format(numberValue);
        if (appendDec) {
            result = result + dec;
        }
        this.debug("i18n:number result: " + result);
        return result;
    }

    private String getString(String key) {
        return this.getString(key, null);
    }

    private String getString(String key, String defaultValue) {
        try {
            String value = this.dictionary.getString("/catalogue/message[@key='" + key + "']");
            return value != null ? value : defaultValue;
        }
        catch (MissingResourceException e) {
            this.debug("Untraslated key: '" + key + "'");
            return defaultValue;
        }
    }

    private void setLocale(Locale locale) {
        this.locale = locale;
    }

    private void debug(String msg) {
        this.getLogger().debug("I18nTransformer: " + msg);
    }

    public void recycle() {
        super.recycle();
        if (this.globalUntranslated != null && !this.untranslated.equals(this.globalUntranslated)) {
            this.untranslated = this.globalUntranslated;
        }
        this.factory.release(this.dictionary);
        this.dictionary = null;
    }

    public void dispose() {
        this.factory.dispose();
        this.factory = null;
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add(I18N_DATE_ELEMENT);
        set.add(I18N_TIME_ELEMENT);
        set.add(I18N_DATE_TIME_ELEMENT);
        dateTypes = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(I18N_NUMBER_ELEMENT);
        set.add(I18N_PERCENT_ELEMENT);
        set.add(I18N_CURRENCY_ELEMENT);
        set.add(I18N_INT_CURRENCY_ELEMENT);
        set.add(I18N_CURRENCY_NO_UNIT_ELEMENT);
        set.add(I18N_INT_CURRENCY_NO_UNIT_ELEMENT);
        numberTypes = Collections.unmodifiableSet(set);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("SHORT", new Integer(3));
        map.put("MEDIUM", new Integer(2));
        map.put("LONG", new Integer(1));
        map.put("FULL", new Integer(0));
        datePatterns = Collections.unmodifiableMap(map);
    }
}

