/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

import java.io.IOException;
import net.sf.pizzacompiler.compiler.AST;
import net.sf.pizzacompiler.compiler.Basic;
import net.sf.pizzacompiler.compiler.Mangle;
import net.sf.pizzacompiler.compiler.Name;
import net.sf.pizzacompiler.compiler.Pool;
import net.sf.pizzacompiler.compiler.Report;
import net.sf.pizzacompiler.compiler.Scope;
import net.sf.pizzacompiler.compiler.Switches;
import net.sf.pizzacompiler.compiler.Symbol;
import net.sf.pizzacompiler.compiler.Type;
import net.sf.pizzacompiler.compiler.TypeSymbol;
import pizza.support.Closure;
import pizza.support.ExceptionWrapper;
import pizza.support.UndeclaredException;

public class ClassSymbol
extends TypeSymbol {
    private Closure _completer;
    Type supertype_p;
    Type supertype_j;
    Type[] interfaces_p;
    Type[] interfaces_j;
    Scope locals_p;
    Scope locals_j;
    Name sourcefile;
    Pool pool;
    int pizzamods = 0;
    private static Type[] emptyInterfaces = new Type[0];
    private static Type[] emptyArgs = new Type[0];

    ClassSymbol(int n, Name name, Type type, Symbol symbol) {
        super(n, name, type, symbol);
        this.setComplete();
        this.supertype_p = null;
        this.supertype_j = null;
        this.interfaces_p = emptyInterfaces;
        this.interfaces_j = emptyInterfaces;
        this.locals_p = null;
        this.locals_j = null;
        this.fullname = Symbol.formFullName(name, symbol);
    }

    ClassSymbol(int n, Name name, Symbol symbol) {
        this(n, name, null, symbol);
        Basic.assert(Type.packageType != null);
        this.type = new Type.ClassType(emptyArgs, Type.packageType).setSym(this);
    }

    ClassSymbol(int n, Name name, Symbol symbol, Closure closure) {
        this(n, name, symbol);
        this._completer = closure;
    }

    public boolean needsCompletion() {
        return this._completer != null;
    }

    public void setComplete() {
        this._completer = null;
    }

    public Name unmangledName() {
        return Mangle.unmangleShort(this.name, this.fullname);
    }

    Name unmangledFullName() {
        return Name.fromString(Mangle.unmangle(this.fullname));
    }

    public Name sourcefile() {
        return this.sourcefile;
    }

    boolean subclass(Symbol symbol) {
        if (this == symbol) {
            return true;
        }
        if ((symbol.modifiers & 0x200) != 0) {
            Type[] typeArray = this.interfaces();
            for (int i = 0; i < typeArray.length; ++i) {
                if (!typeArray[i].tsym().subclass(symbol)) continue;
                return true;
            }
        } else {
            Type type;
            TypeSymbol typeSymbol = this;
            do {
                if ((type = ((TypeSymbol)typeSymbol).supertype()) != null) continue;
                return false;
            } while ((typeSymbol = type.tsym()) != symbol);
            return true;
        }
        return false;
    }

    public String toString() {
        return String.valueOf((this.modifiers & 0x200) != 0 ? "interface " : "class ").concat(String.valueOf(Mangle.unmangle(this.fullname)));
    }

    boolean isTypeVar() {
        return false;
    }

    void tryComplete() {
        try {
            this.complete();
        }
        catch (IOException iOException) {
            Report.error(AST.getPos(), String.valueOf(String.valueOf(String.valueOf("error while loading class ").concat(String.valueOf(this.fullname))).concat(String.valueOf(": "))).concat(String.valueOf(iOException)));
        }
    }

    void complete() throws IOException {
        if (this.needsCompletion()) {
            Closure closure = this._completer;
            this.setComplete();
            try {
                closure.$apply(this);
            }
            catch (ExceptionWrapper exceptionWrapper) {
                if (exceptionWrapper.thrown instanceof IOException) {
                    throw (IOException)exceptionWrapper.thrown;
                }
                throw new UndeclaredException();
            }
        }
    }

    public Type supertype() {
        if (this.needsCompletion()) {
            this.tryComplete();
        }
        return Switches.pizza ? this.supertype_p : this.supertype_j;
    }

    public Type[] interfaces() {
        if (this.needsCompletion()) {
            this.tryComplete();
        }
        return Switches.pizza ? this.interfaces_p : this.interfaces_j;
    }

    int caseNum() {
        this.tryComplete();
        return this.modifiers >>> 22;
    }

    Scope locals() {
        if (this.needsCompletion()) {
            this.tryComplete();
        }
        return Switches.pizza ? this.locals_p : this.locals_j;
    }

    void setSupertype(Type type) {
        if (Switches.pizza) {
            this.supertype_p = type;
            if (this.supertype_j == null) {
                this.supertype_j = type;
            }
        } else {
            this.supertype_j = type;
        }
    }

    void setInterfaces(Type[] typeArray) {
        if (Switches.pizza) {
            this.interfaces_p = typeArray;
            if (this.interfaces_j == emptyInterfaces) {
                this.interfaces_j = typeArray;
            }
        } else {
            this.interfaces_j = typeArray;
        }
    }

    void setLocals(Scope scope) {
        if (Switches.pizza) {
            this.locals_p = scope;
            if (this.locals_j == null) {
                this.locals_j = scope;
            }
        } else {
            this.locals_j = scope;
        }
    }
}

