/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.portlet;

import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public final class PortletObjectModelHelper {
    public static final String RENDER_REQUEST_OBJECT = "render-request";
    public static final String ACTION_REQUEST_OBJECT = "action-request";
    public static final String RENDER_RESPONSE_OBJECT = "render-response";
    public static final String ACTION_RESPONSE_OBJECT = "action-response";
    public static final String PORTLET_REQUEST_OBJECT = "portlet-request";
    public static final String PORTLET_RESPONSE_OBJECT = "portlet-response";
    public static final String PORTLET_CONTEXT_OBJECT = "portlet-context";

    private PortletObjectModelHelper() {
    }

    public static final RenderRequest getRenderRequest(Map objectModel) {
        return (RenderRequest)objectModel.get(RENDER_REQUEST_OBJECT);
    }

    public static final RenderResponse getRenderResponse(Map objectModel) {
        return (RenderResponse)objectModel.get(RENDER_RESPONSE_OBJECT);
    }

    public static final ActionRequest getActionRequest(Map objectModel) {
        return (ActionRequest)objectModel.get(ACTION_REQUEST_OBJECT);
    }

    public static final ActionResponse getActionResponse(Map objectModel) {
        return (ActionResponse)objectModel.get(ACTION_RESPONSE_OBJECT);
    }

    public static final PortletRequest getPortletRequest(Map objectModel) {
        return (PortletRequest)objectModel.get(PORTLET_REQUEST_OBJECT);
    }

    public static final PortletResponse getPortletResponse(Map objectModel) {
        return (PortletResponse)objectModel.get(PORTLET_RESPONSE_OBJECT);
    }

    public static final PortletContext getPortletContext(Map objectModel) {
        return (PortletContext)objectModel.get(PORTLET_CONTEXT_OBJECT);
    }

    public static final void setPortletRequest(Map objectModel, PortletRequest object) {
        if (objectModel.get(PORTLET_REQUEST_OBJECT) != null) {
            throw new IllegalStateException("PortletRequest has been set already");
        }
        objectModel.put(PORTLET_REQUEST_OBJECT, object);
        if (object instanceof ActionRequest) {
            objectModel.put(ACTION_REQUEST_OBJECT, object);
        }
        if (object instanceof RenderRequest) {
            objectModel.put(RENDER_REQUEST_OBJECT, object);
        }
    }

    public static final void setPortletResponse(Map objectModel, PortletResponse object) {
        if (objectModel.get(PORTLET_RESPONSE_OBJECT) != null) {
            throw new IllegalStateException("PortletResponse has been set already");
        }
        objectModel.put(PORTLET_RESPONSE_OBJECT, object);
        if (object instanceof ActionResponse) {
            objectModel.put(ACTION_RESPONSE_OBJECT, object);
        }
        if (object instanceof RenderResponse) {
            objectModel.put(RENDER_RESPONSE_OBJECT, object);
        }
    }

    public static final void setPortletContext(Map objectModel, PortletContext object) {
        if (objectModel.get(PORTLET_CONTEXT_OBJECT) != null) {
            throw new IllegalStateException("PortletContext has been set already");
        }
        objectModel.put(PORTLET_CONTEXT_OBJECT, object);
    }
}

