/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.components.elementprocessor.CannotCreateElementProcessorException;
import org.apache.cocoon.components.elementprocessor.ElementProcessor;
import org.apache.cocoon.components.elementprocessor.ElementProcessorFactory;

public abstract class AbstractElementProcessorFactory
extends AbstractLogEnabled
implements ElementProcessorFactory,
Component {
    private Map _element_processor_map = new HashMap();

    protected AbstractElementProcessorFactory() {
    }

    public ElementProcessor createElementProcessor(String name) throws CannotCreateElementProcessorException {
        Object progenitor = this.lookupElementProcessorProgenitor(name);
        if (progenitor == null) {
            CannotCreateElementProcessorException exception = new CannotCreateElementProcessorException("Cannot find progenitor for that name");
            exception.setElementName(name);
            throw exception;
        }
        ElementProcessor processor = null;
        try {
            processor = this.doCreateElementProcessor(progenitor);
        }
        catch (CannotCreateElementProcessorException e) {
            e.setElementName(name);
            throw e;
        }
        return processor;
    }

    protected void addElementProcessorProgenitor(String name, Object progenitor) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Cannot use null or empty name as a key");
        }
        if (progenitor == null) {
            throw new IllegalArgumentException("Cannot add null progenitor to the map");
        }
        if (this._element_processor_map.put(name, progenitor) != null) {
            throw new IllegalArgumentException(name + " is already in use in the map");
        }
    }

    protected Object lookupElementProcessorProgenitor(String name) {
        Object obj = this._element_processor_map.get(name);
        if (obj == null && !name.equals("*")) {
            obj = this.lookupElementProcessorProgenitor("*");
        }
        return obj;
    }

    protected abstract ElementProcessor doCreateElementProcessor(Object var1) throws CannotCreateElementProcessorException;

    protected ElementProcessor createNewElementProcessorInstance(Class progenitor) throws CannotCreateElementProcessorException {
        ElementProcessor rval = null;
        try {
            rval = (ElementProcessor)progenitor.newInstance();
            if (rval instanceof AbstractLogEnabled) {
                ((AbstractLogEnabled)rval).enableLogging(this.getLogger());
            }
        }
        catch (ExceptionInInitializerError e) {
            throw new CannotCreateElementProcessorException("an exception (" + e + ") occurred in initializing the associated ElementProcessor class");
        }
        catch (SecurityException e) {
            throw new CannotCreateElementProcessorException("a security exception was caught while creating the associated ElementProcessor");
        }
        catch (InstantiationException e) {
            throw new CannotCreateElementProcessorException("associated ElementProcessor is an interface or abstract class or has no zero-parameter constructor");
        }
        catch (IllegalAccessException e) {
            throw new CannotCreateElementProcessorException("cannot access ElementProcessor class or its zero-parameter constructor");
        }
        catch (ClassCastException e) {
            throw new CannotCreateElementProcessorException("object created does not implement ElementProcessor");
        }
        catch (Exception e) {
            throw new CannotCreateElementProcessorException("exception (" + e + ") occured while creating new instance of ElementProcessor");
        }
        if (rval == null) {
            throw new CannotCreateElementProcessorException("somehow generated a null ElementProcessor");
        }
        return rval;
    }

    protected ElementProcessor constructElementProcessor(Constructor progenitor) throws CannotCreateElementProcessorException {
        ElementProcessor rval = null;
        try {
            rval = (ElementProcessor)progenitor.newInstance(new Object[0]);
            if (rval instanceof AbstractLogEnabled) {
                ((AbstractLogEnabled)rval).enableLogging(this.getLogger());
            }
        }
        catch (ExceptionInInitializerError e) {
            throw new CannotCreateElementProcessorException("an exception (" + e + ")occurred in initializing the associated ElementProcessor class");
        }
        catch (IllegalArgumentException e) {
            throw new CannotCreateElementProcessorException("the ElementProcessor constructor apparently needs parameters");
        }
        catch (InstantiationException e) {
            throw new CannotCreateElementProcessorException("associated ElementProcessor is an interface or abstract class");
        }
        catch (IllegalAccessException e) {
            throw new CannotCreateElementProcessorException("cannot access ElementProcessor class or its zero-parameter constructor");
        }
        catch (InvocationTargetException e) {
            throw new CannotCreateElementProcessorException("ElementProcessor constructor threw an exception [" + e.toString() + "]");
        }
        catch (ClassCastException e) {
            throw new CannotCreateElementProcessorException("object created does not implement ElementProcessor");
        }
        if (rval == null) {
            throw new CannotCreateElementProcessorException("somehow generated a null ElementProcessor");
        }
        return rval;
    }
}

