/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.mail.datasource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.apache.cocoon.servlet.multipart.Part;

public class FilePartDataSource
implements DataSource {
    private Part part;
    private String contentType = null;
    private String name = null;

    public FilePartDataSource(Part part) {
        this(part, null, null);
    }

    public FilePartDataSource(Part part, String type, String name) {
        this.part = part;
        this.contentType = type;
        this.name = name;
        if (this.isNullOrEmpty(this.name)) {
            this.name = null;
        }
        if (this.isNullOrEmpty(this.contentType)) {
            this.contentType = null;
        }
    }

    private boolean isNullOrEmpty(String str) {
        return str == null || "".equals(str) || "null".equals(str);
    }

    public String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        String mimeType = this.part.getMimeType();
        if (this.isNullOrEmpty(mimeType)) {
            mimeType = "application/octet-stream";
        }
        return mimeType;
    }

    public InputStream getInputStream() throws IOException {
        InputStream inp;
        try {
            inp = this.part.getInputStream();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return inp;
    }

    public String getName() {
        String name;
        String string = name = this.name != null ? this.name : this.part.getFileName();
        if (this.isNullOrEmpty(name)) {
            name = "attachment";
        }
        return name;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("no data sink available");
    }
}

