/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.event.command;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.StaticBucketMap;
import org.apache.excalibur.event.DequeueInterceptor;
import org.apache.excalibur.event.EventHandler;
import org.apache.excalibur.event.Queue;
import org.apache.excalibur.event.Source;
import org.apache.excalibur.event.command.EventPipeline;
import org.apache.excalibur.event.command.ThreadManager;
import org.apache.excalibur.event.impl.NullDequeueInterceptor;

public final class TPSPThreadManager
implements ThreadManager {
    private final StaticBucketMap m_pipelines = new StaticBucketMap();
    private final int m_maxThreadsPerPool;
    private final int m_threshold;
    private final int m_margin;

    public TPSPThreadManager() {
        this(2, 1000);
    }

    public TPSPThreadManager(int maxThreadPerPool, int threshold) {
        this(maxThreadPerPool, threshold, threshold / 4);
    }

    public TPSPThreadManager(int maxThreadPerPool, int threshold, int margin) {
        this.m_maxThreadsPerPool = maxThreadPerPool;
        this.m_threshold = threshold;
        this.m_margin = margin;
    }

    public void register(EventPipeline pipeline) {
        Source[] sources = pipeline.getSources();
        EventHandler handler = pipeline.getEventHandler();
        ArrayList<SourceDequeueInterceptor> sourceList = new ArrayList<SourceDequeueInterceptor>(sources.length);
        int i = 0;
        while (i < sources.length) {
            PooledExecutor threadPool = new PooledExecutor();
            threadPool.setMinimumPoolSize(1);
            threadPool.setMaximumPoolSize(this.m_maxThreadsPerPool);
            SourceRunner initRunner = new SourceRunner(sources[i], handler);
            try {
                threadPool.execute((Runnable)initRunner);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            sourceList.add(new SourceDequeueInterceptor(initRunner, handler, threadPool, this.m_threshold, this.m_margin));
            ++i;
        }
        this.m_pipelines.put((Object)pipeline, sourceList);
    }

    public void deregister(EventPipeline pipeline) {
        List sources = (List)this.m_pipelines.remove((Object)pipeline);
        Iterator it = sources.iterator();
        while (it.hasNext()) {
            SourceDequeueInterceptor intercept = (SourceDequeueInterceptor)it.next();
            intercept.stop();
        }
    }

    public void deregisterAll() {
        Iterator it = this.m_pipelines.keySet().iterator();
        while (it.hasNext()) {
            this.deregister((EventPipeline)it.next());
        }
    }

    protected static final class SourceDequeueInterceptor
    implements DequeueInterceptor {
        private final Source m_source;
        private final PooledExecutor m_threadPool;
        private final int m_threshold;
        private final DequeueInterceptor m_parent;
        private final int m_margin;
        private final LinkedList m_runners;
        private final EventHandler m_handler;
        private final SourceRunner m_initRunner;

        public SourceDequeueInterceptor(SourceRunner runner, EventHandler handler, PooledExecutor threadPool, int threshold, int margin) {
            if (runner == null) {
                throw new NullPointerException("runner");
            }
            if (handler == null) {
                throw new NullPointerException("handler");
            }
            if (threadPool == null) {
                throw new NullPointerException("threadPool");
            }
            if (threshold < threadPool.getMinimumPoolSize()) {
                throw new IllegalArgumentException("threshold must be higher than the minimum number of threads for the pool");
            }
            if (margin < 0) {
                throw new IllegalArgumentException("margin must not be less then zero");
            }
            if (threshold - margin <= threadPool.getMinimumPoolSize()) {
                throw new IllegalArgumentException("The margin must not exceed or equal the differnece between threshold and the thread pool minimum size");
            }
            this.m_source = runner.getSource();
            this.m_initRunner = runner;
            this.m_threadPool = threadPool;
            this.m_threshold = threshold;
            this.m_runners = new LinkedList();
            this.m_handler = handler;
            if (this.m_source instanceof Queue) {
                Queue queue = (Queue)this.m_source;
                this.m_parent = queue.getDequeueInterceptor();
                queue.setDequeueInterceptor((DequeueInterceptor)this);
            } else {
                this.m_parent = new NullDequeueInterceptor();
            }
            this.m_margin = margin;
        }

        public void before(Source context) {
            if (this.m_source.size() > this.m_threshold + this.m_margin) {
                SourceRunner runner = new SourceRunner(this.m_source, this.m_handler);
                try {
                    this.m_threadPool.execute((Runnable)runner);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.m_runners.add(runner);
            }
            this.m_parent.before(context);
        }

        public void after(Source context) {
            this.m_parent.after(context);
            if (this.m_source.size() < this.m_threshold - this.m_margin && this.m_runners.size() > 0) {
                SourceRunner runner = (SourceRunner)this.m_runners.removeFirst();
                runner.stop();
            }
        }

        public void stop() {
            Iterator it = this.m_runners.iterator();
            while (it.hasNext()) {
                ((SourceRunner)it.next()).stop();
            }
            this.m_initRunner.stop();
        }
    }

    protected static final class SourceRunner
    implements Runnable {
        private final Source m_source;
        private final EventHandler m_handler;
        private volatile boolean m_keepProcessing;

        protected SourceRunner(Source source, EventHandler handler) {
            if (source == null) {
                throw new NullPointerException("source");
            }
            if (handler == null) {
                throw new NullPointerException("handler");
            }
            this.m_source = source;
            this.m_handler = handler;
            this.m_keepProcessing = true;
        }

        public void run() {
            while (this.m_keepProcessing) {
                Object event = this.m_source.dequeue();
                if (event != null) {
                    this.m_handler.handleEvent(event);
                }
                SourceRunner.yield();
            }
        }

        private static void yield() {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void stop() {
            this.m_keepProcessing = false;
        }

        public Source getSource() {
            return this.m_source;
        }
    }
}

