/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import java.io.PrintStream;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMLocator;
import org.xml.sax.SAXException;

public class StandardErrorListener
implements ErrorListener {
    int recoveryPolicy = 1;
    int warningCount = 0;
    PrintStream errorOutput = System.err;

    public void setErrorOutput(PrintStream printStream) {
        this.errorOutput = printStream;
    }

    public void setRecoveryPolicy(int n) {
        this.recoveryPolicy = n;
    }

    public void warning(TransformerException transformerException) throws TransformerException {
        if (this.recoveryPolicy == 0) {
            return;
        }
        String string = "";
        if (transformerException.getLocator() != null) {
            string = StandardErrorListener.getLocationMessage(transformerException) + "\n  ";
        }
        string = string + StandardErrorListener.getExpandedMessage(transformerException);
        if (this.recoveryPolicy == 1) {
            this.errorOutput.println("Recoverable error");
            this.errorOutput.println(string);
            ++this.warningCount;
            if (this.warningCount > 25) {
                System.err.println("No more warnings will be displayed");
                this.recoveryPolicy = 0;
                this.warningCount = 0;
            }
        } else {
            this.errorOutput.println("Recoverable error");
            this.errorOutput.println(string);
            this.errorOutput.println("Processing terminated because error recovery is disabled");
            throw new TransformerException(transformerException);
        }
    }

    public void error(TransformerException transformerException) throws TransformerException {
        String string = "Error " + StandardErrorListener.getLocationMessage(transformerException) + "\n  " + StandardErrorListener.getExpandedMessage(transformerException);
        this.errorOutput.println(string);
    }

    public void fatalError(TransformerException transformerException) throws TransformerException {
        this.error(transformerException);
        throw transformerException;
    }

    public static String getLocationMessage(TransformerException transformerException) {
        SourceLocator sourceLocator = transformerException.getLocator();
        if (sourceLocator == null) {
            return "";
        }
        String string = "";
        if (sourceLocator instanceof DOMLocator) {
            string = string + "at " + ((DOMLocator)sourceLocator).getOriginatingNode().getNodeName() + " ";
        }
        int n = sourceLocator.getLineNumber();
        int n2 = sourceLocator.getColumnNumber();
        if (n < 0 && n2 > 0) {
            string = string + "at byte " + n2 + " ";
        } else {
            string = string + "on line " + n + " ";
            if (sourceLocator.getColumnNumber() != -1) {
                string = string + "column " + n2 + " ";
            }
        }
        string = string + "of " + sourceLocator.getSystemId() + ":";
        return string;
    }

    public static String getExpandedMessage(TransformerException transformerException) {
        String string = "";
        Throwable throwable = transformerException;
        while (throwable != null) {
            String string2 = throwable.getMessage();
            if (!string2.equals("TRaX Transform Exception") && !string.endsWith(string2)) {
                if (!string.equals("")) {
                    string = string + ": ";
                }
                string = string + throwable.getMessage();
            }
            if (throwable instanceof TransformerException) {
                throwable = ((TransformerException)throwable).getException();
                continue;
            }
            if (!(throwable instanceof SAXException)) break;
            throwable = ((SAXException)throwable).getException();
        }
        return string;
    }
}

