/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.source.impl.WebDAVSource;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceFactory;

public class WebDAVSourceFactory
extends AbstractLogEnabled
implements SourceFactory,
Configurable,
ThreadSafe {
    private String protocol;
    private boolean secure;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.protocol = configuration.getAttribute("name");
        Parameters parameters = Parameters.fromConfiguration((Configuration)configuration);
        this.secure = parameters.getParameterAsBoolean("secure", false);
    }

    public Source getSource(String location, Map parameters) throws MalformedURLException, IOException, SourceException {
        int index;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Creating source object for " + location);
        }
        if ((index = location.indexOf(58)) != -1) {
            location = location.substring(index + 3);
        }
        Object url = this.secure ? new HttpsURL("https://" + location) : new HttpURL("http://" + location);
        return WebDAVSource.newWebDAVSource((HttpURL)url, this.protocol, this.getLogger());
    }

    public void release(Source source) {
    }
}

