package fr.gouv.culture.sdx.documentbase;

import org.apache.excalibur.source.SourceValidity;

/**
 * A source validity for a document base.
 * 
 * <p>The source is not valid is the document base has been updated.</p>
 * <p>This is used to cache pages when document base has not been updated.</p>
 */
public class DocumentBaseSourceValidity implements SourceValidity {
	
	/** The timestamp of the document base */
	private long timestamp;
	
	/**
	 * Creates a source validity from a document base.
	 * 
	 * @param d		The document base.
	 */
	public DocumentBaseSourceValidity(DocumentBase d) {
		// Simply keeps a reference to the DB 
		this.timestamp = d.lastModificationDate().getTime();
	}

	/**
	 * Checks to see if it is valid. Always return 0 (= don't know).
	 */
	public int isValid() {
		return 0;
	}

	/**
	 * Checks to see if it is valid agains a new validity.
	 * 
	 * @param newValidity	The new validity object.
	 */
	public int isValid(SourceValidity newValidity) {
		if ( newValidity instanceof DocumentBaseSourceValidity ) {
			if ( timestamp == ((DocumentBaseSourceValidity)newValidity).getTimeStamp() ) return 1;
			else return -1;
		}
		else return -1;	// Wrong object, not valid anymore... (Excalibur classes do that...)
	}
	
	/**
	 * Returns the current timestamp
	 */
	public long getTimeStamp() {
		return timestamp;
	}

}
