/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.util.apache.cocoon.xml;

import fr.gouv.culture.util.apache.avalon.excalibur.concurrent.Mutex;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.cocoon.xml.XMLConsumer;

/**
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: Jun 2, 2003
 * Time: 2:45:02 PM
 * To change this template use Options | File Templates.
 */
public abstract class AbstractSynchronizedXMLProducer extends Mutex implements SynchronizedXMLProducer, Recyclable {

    /** The <code>XMLConsumer</code> receiving SAX events. */
    protected SynchronizedXMLConsumer synchronizedXmlConsumer;

    /**
     * Set the <code>XMLConsumer</code> that will receive XML data.
     * <br>
     */
    public void setConsumer(SynchronizedXMLConsumer consumer) {
        this.synchronizedXmlConsumer = consumer;
    }

    /**
     * Set the <code>XMLConsumer</code> that will receive XML data.
     * Note we will attempt to synchronize this internally. Do not use
     * this method if peforming synchronization externally on the provided
     * consumer as this will cause deadlock since we synchronize internally.
     * To be safe use @see setConsumer(SynchronizedXMLConsumer consumer).
     * <br>
     */
    public void setConsumer(XMLConsumer consumer) {
        if (consumer != null)
            this.setConsumer(new SynchronizedXMLConsumerWrapper(consumer));
    }

    /**
     * Recycle the producer by removing references
     */
    public void recycle() {
        this.synchronizedXmlConsumer = null;
    }

}
