/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class NativeJavaPackage
extends ScriptableObject {
    static final long serialVersionUID = 7445054382212031523L;
    private String packageName;
    private ClassLoader classLoader;

    NativeJavaPackage(boolean internalUsage, String packageName, ClassLoader classLoader) {
        this.packageName = packageName;
        this.classLoader = classLoader;
    }

    public NativeJavaPackage(String packageName, ClassLoader classLoader) {
        this(false, packageName, classLoader);
    }

    public NativeJavaPackage(String packageName) {
        this(false, packageName, Context.getCurrentContext().getApplicationClassLoader());
    }

    public String getClassName() {
        return "JavaPackage";
    }

    public boolean has(String id, Scriptable start) {
        return true;
    }

    public boolean has(int index, Scriptable start) {
        return false;
    }

    public void put(String id, Scriptable start, Object value) {
    }

    public void put(int index, Scriptable start, Object value) {
        throw Context.reportRuntimeError0("msg.pkg.int");
    }

    public Object get(String id, Scriptable start) {
        return this.getPkgProperty(id, start, true);
    }

    public Object get(int index, Scriptable start) {
        return Scriptable.NOT_FOUND;
    }

    void forcePackage(String name, Scriptable scope) {
        NativeJavaPackage pkg;
        String id;
        Object cached;
        int end = name.indexOf(46);
        if (end == -1) {
            end = name.length();
        }
        if ((cached = super.get(id = name.substring(0, end), (Scriptable)this)) != null && cached instanceof NativeJavaPackage) {
            pkg = (NativeJavaPackage)cached;
        } else {
            String newPackage = this.packageName.length() == 0 ? id : this.packageName + "." + id;
            pkg = new NativeJavaPackage(true, newPackage, this.classLoader);
            ScriptRuntime.setObjectProtoAndParent(pkg, scope);
            super.put(id, (Scriptable)this, (Object)pkg);
        }
        if (end < name.length()) {
            pkg.forcePackage(name.substring(end + 1), scope);
        }
    }

    synchronized Object getPkgProperty(String name, Scriptable start, boolean createPkg) {
        Object cached = super.get(name, start);
        if (cached != Scriptable.NOT_FOUND) {
            return cached;
        }
        String className = this.packageName.length() == 0 ? name : this.packageName + '.' + name;
        Context cx = Context.getContext();
        ClassShutter shutter = cx.getClassShutter();
        Scriptable newValue = null;
        if (shutter == null || shutter.visibleToScripts(className)) {
            Class cl = null;
            cl = this.classLoader != null ? Kit.classOrNull(this.classLoader, className) : Kit.classOrNull(className);
            if (cl != null) {
                newValue = new NativeJavaClass(ScriptableObject.getTopLevelScope(this), cl);
                newValue.setPrototype(this.getPrototype());
            }
        }
        if (newValue == null && createPkg) {
            NativeJavaPackage pkg = new NativeJavaPackage(true, className, this.classLoader);
            ScriptRuntime.setObjectProtoAndParent(pkg, this.getParentScope());
            newValue = pkg;
        }
        if (newValue != null) {
            super.put(name, start, newValue);
        }
        return newValue;
    }

    public Object getDefaultValue(Class ignored) {
        return this.toString();
    }

    public String toString() {
        return "[JavaPackage " + this.packageName + "]";
    }
}

