/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.matching;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.matching.AbstractRegexpMatcher;
import org.apache.regexp.RE;
import org.apache.regexp.REProgram;

public class RegexpURIDefaultsMatcher
extends AbstractRegexpMatcher {
    public Map preparedMatch(Object preparedPattern, Map objectModel, Parameters parameters) {
        RE re = new RE((REProgram)preparedPattern);
        String match = this.getMatchString(objectModel, parameters);
        if (match == null) {
            return null;
        }
        if (re.match(match)) {
            int parenCount = re.getParenCount();
            HashMap<String, String> map = new HashMap<String, String>();
            this.mapDefaults(parameters, map);
            int paren = 0;
            while (paren <= parenCount) {
                this.getLogger().debug("Matched " + String.valueOf(Integer.toString(paren)) + " " + String.valueOf(re.getParen(paren)));
                map.put(Integer.toString(paren), re.getParen(paren));
                ++paren;
            }
            return map;
        }
        return null;
    }

    protected String getMatchString(Map objectModel, Parameters parameters) {
        String uri = ObjectModelHelper.getRequest((Map)objectModel).getSitemapURI();
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        return uri;
    }

    protected void mapDefaults(Parameters parameters, Map map) {
        String[] parameterNames = parameters.getNames();
        String MAP_DEFAULT_PREFIX = "map-default:";
        int MAP_DEFAULT_PREFIX_LENGTH = "map-default:".length();
        int i = 0;
        while (i < parameterNames.length) {
            if (parameterNames[i].startsWith("map-default:")) {
                String entry = parameterNames[i];
                String defaultEntry = entry.substring(MAP_DEFAULT_PREFIX_LENGTH);
                String defaultValue = parameters.getParameter(entry, null);
                if (defaultValue != null) {
                    this.getLogger().debug("Setting defaultEntry " + String.valueOf(defaultEntry) + ", " + "defaultValue " + String.valueOf(defaultValue));
                    map.put(defaultEntry, defaultValue);
                }
            }
            ++i;
        }
    }
}

