/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.pluto.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.portal.pluto.factory.AbstractFactory;
import org.apache.cocoon.portal.pluto.factory.LocalPortletInvokerImpl;
import org.apache.cocoon.portal.pluto.om.PortletDefinitionImpl;
import org.apache.pluto.factory.PortletInvokerFactory;
import org.apache.pluto.invoker.PortletInvoker;
import org.apache.pluto.invoker.impl.PortletInvokerImpl;
import org.apache.pluto.om.portlet.PortletDefinition;

public class PortletInvokerFactoryImpl
extends AbstractFactory
implements PortletInvokerFactory,
Serviceable,
Contextualizable,
ThreadSafe,
Disposable {
    protected Context context;
    protected ServiceManager manager;
    protected List localPortlets = Collections.synchronizedList(new ArrayList());

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void dispose() {
        Iterator i = this.localPortlets.iterator();
        while (i.hasNext()) {
            LocalPortletInvokerImpl current = (LocalPortletInvokerImpl)((Object)i.next());
            current.destroy();
        }
        this.localPortlets.clear();
        this.manager = null;
        this.context = null;
    }

    public PortletInvoker getPortletInvoker(PortletDefinition portletDefinition) {
        PortletInvoker invoker;
        boolean local = false;
        if (portletDefinition instanceof PortletDefinitionImpl) {
            local = ((PortletDefinitionImpl)portletDefinition).isLocalPortlet();
        }
        if (local) {
            invoker = ((PortletDefinitionImpl)portletDefinition).getLocalPortletInvoker();
            if (invoker == null) {
                invoker = new LocalPortletInvokerImpl(portletDefinition, this.servletConfig);
                this.localPortlets.add(invoker);
                ((PortletDefinitionImpl)portletDefinition).setLocalPortletInvoker(invoker);
                try {
                    ContainerUtil.enableLogging((Object)invoker, (Logger)this.getLogger());
                    ContainerUtil.contextualize((Object)invoker, (Context)this.context);
                    ContainerUtil.service((Object)invoker, (ServiceManager)this.manager);
                    ContainerUtil.initialize((Object)invoker);
                }
                catch (Exception ignore) {
                    this.getLogger().warn("Unable to initialize local portlet invoker.", (Throwable)ignore);
                }
            }
        } else {
            invoker = new PortletInvokerImpl(portletDefinition, this.servletConfig);
        }
        return invoker;
    }

    public void releasePortletInvoker(PortletInvoker invoker) {
    }
}

