/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManager;
import org.apache.excalibur.instrument.manager.InstrumentDescriptor;
import org.apache.excalibur.instrument.manager.InstrumentSampleDescriptor;
import org.apache.excalibur.instrument.manager.NoSuchInstrumentException;
import org.apache.excalibur.instrument.manager.http.AbstractHTMLHandler;
import org.apache.excalibur.instrument.manager.http.InstrumentManagerHTTPConnector;
import org.apache.excalibur.instrument.manager.http.server.HTTPRedirect;

public class HTMLCreateSampleHandler
extends AbstractHTMLHandler {
    private InstrumentManagerHTTPConnector m_connector;

    public HTMLCreateSampleHandler(DefaultInstrumentManager manager, InstrumentManagerHTTPConnector connector) {
        super("/create-sample.html", manager);
        this.m_connector = connector;
    }

    public void doGet(String path, Map parameters, PrintWriter out) throws IOException {
        InstrumentSampleDescriptor sample;
        InstrumentDescriptor desc;
        String name = this.getParameter(parameters, "name");
        String description = this.getParameter(parameters, "description");
        long interval = this.getLongParameter(parameters, "interval");
        int size = this.getIntegerParameter(parameters, "size");
        long lease = this.getLongParameter(parameters, "lease");
        int type = this.getIntegerParameter(parameters, "type");
        try {
            desc = this.getInstrumentManager().locateInstrumentDescriptor(name);
        }
        catch (NoSuchInstrumentException e) {
            int pos = name.lastIndexOf(46);
            if (pos >= 0) {
                throw new HTTPRedirect("instrumentable.html?name=" + this.urlEncode(name.substring(0, pos)));
            }
            throw new HTTPRedirect("instrument-manager.html");
        }
        size = Math.max(1, Math.min(size, this.m_connector.getMaxLeasedSampleSize()));
        lease = Math.max(1L, Math.min(lease, this.m_connector.getMaxLeasedSampleLease()));
        if (this.getInstrumentManager().getLeaseSampleCount() >= this.m_connector.getMaxLeasedSamples()) {
            lease = 1L;
        }
        try {
            sample = desc.createInstrumentSample(description, interval, size, lease, type);
        }
        catch (IllegalArgumentException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        catch (IllegalStateException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        throw new HTTPRedirect("sample.html?name=" + this.urlEncode(sample.getName()));
    }
}

