/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.pipeline;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ElementFilter extends TagFilter {

    protected boolean _withinFilteredElement = false;
    protected int _filteredCount = 0;

    public void startElement(String uri, String loc, String raw, Attributes a)
            throws SAXException {
        setCurrentElementProperties(uri, loc, raw, a);
        boolean send = shouldSendElementEvent(uri, loc, raw, a);
        if (send == super._send)
            this._filteredCount++;
        if (send) {
            if (super.xmlConsumer != null)
                super.xmlConsumer.startElement(uri, loc, raw, a);
        }
    }

    public void characters(char c[], int start, int len)
            throws SAXException {
        boolean send = shouldSendElementEvent(c_uri, c_loc, c_raw, super.peekCurrentAttributes());
        if (send) {
            if (super.xmlConsumer != null)
                super.xmlConsumer.characters(c, start, len);
        }
    }

    public void endElement(String uri, String loc, String raw)
            throws SAXException {
        boolean send = shouldSendElementEvent(uri, loc, raw, super.peekCurrentAttributes());
        if (send == super._send) {
            this._filteredCount--;
            if (this._filteredCount == 0)
                this._withinFilteredElement = false;
        }
        if (send) {
            if (super.xmlConsumer != null)
                super.xmlConsumer.endElement(uri, loc, raw);
        }
        resetCurrentElementProperties(uri, loc, raw);
    }


    protected boolean shouldSendElementEvent(String uri, String loc, String raw, Attributes a) {
        boolean send = super.shouldSendElementEvent(uri, loc, raw, a);
        return withinFilteredElement(send);
    }


    protected boolean withinFilteredElement(boolean shouldSendElementEvent) {
        boolean send = shouldSendElementEvent;
        if (shouldSendElementEvent == super._send)
            this._withinFilteredElement = true;
        if (this._withinFilteredElement == true || this._filteredCount > 0)
            send = super._send;

        return send;
    }

    protected void resetFields() {
        super.resetFields();
        _withinFilteredElement = false;
        _filteredCount = 0;
    }

    public void recycle() {
        super.recycle();
        this.resetFields();
    }
}
