/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms;

import java.io.IOException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.forms.CacheManager;
import org.apache.commons.collections.FastHashMap;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceValidity;

public class DefaultCacheManager
extends AbstractLogEnabled
implements CacheManager,
ThreadSafe,
Serviceable,
Disposable,
Configurable,
Component {
    protected ServiceManager manager;
    protected Configuration configuration;
    protected FastHashMap cache = new FastHashMap();

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.manager = serviceManager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
    }

    public Object get(Source source, String prefix) {
        boolean isValid;
        String key = prefix + source.getURI();
        SourceValidity newValidity = source.getValidity();
        if (newValidity == null) {
            this.cache.remove((Object)key);
            return null;
        }
        Object[] objectAndValidity = (Object[])this.cache.get((Object)key);
        if (objectAndValidity == null) {
            return null;
        }
        SourceValidity storedValidity = (SourceValidity)objectAndValidity[1];
        int valid = storedValidity.isValid();
        if (valid == 0) {
            valid = storedValidity.isValid(newValidity);
            isValid = valid == 1;
        } else {
            boolean bl = isValid = valid == 1;
        }
        if (!isValid) {
            this.cache.remove((Object)key);
            return null;
        }
        return objectAndValidity[0];
    }

    public void set(Object object, Source source, String prefix) throws IOException {
        String key = prefix + source.getURI();
        SourceValidity validity = source.getValidity();
        if (validity != null) {
            Object[] objectAndValidity = new Object[]{object, validity};
            this.cache.put((Object)key, (Object)objectAndValidity);
        }
    }

    public void dispose() {
        this.manager = null;
        this.cache = null;
    }
}

