/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.taglib.core;

import java.util.Map;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.taglib.IterationTag;
import org.apache.cocoon.taglib.VarTagSupport;
import org.apache.cocoon.taglib.core.LoopTag;
import org.apache.cocoon.taglib.core.LoopTagStatus;
import org.apache.cocoon.taglib.core.LoopTagSupport;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class LoopTagSupport
extends VarTagSupport
implements LoopTag,
IterationTag {
    protected int begin;
    protected int end;
    protected int step;
    protected boolean beginSpecified;
    protected boolean endSpecified;
    protected boolean stepSpecified;
    protected String statusId;
    private LoopTagStatus status;
    private Object item;
    protected int index;
    protected int count;
    protected boolean last;

    public LoopTagSupport() {
        this.init();
    }

    protected abstract Object next() throws SAXException;

    protected abstract boolean hasNext() throws SAXException;

    protected abstract void prepare() throws SAXException;

    public void recycle() {
        this.unExposeVariables();
        this.init();
        super.recycle();
    }

    public int doStartTag(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.end != -1 && this.begin > this.end) {
            throw new SAXException("begin (" + this.begin + ") > end (" + this.end + ")");
        }
        this.index = 0;
        this.count = 1;
        this.last = false;
        this.prepare();
        this.discardIgnoreSubset(this.begin);
        if (!this.hasNext()) {
            return 1;
        }
        this.item = this.next();
        this.discard(this.step - 1);
        this.exposeVariables();
        this.calibrateLast();
        return 0;
    }

    public int doAfterBody() throws SAXException {
        this.index += this.step - 1;
        ++this.count;
        if (this.hasNext() && !this.atEnd()) {
            ++this.index;
        } else {
            return 1;
        }
        this.item = this.next();
        this.discard(this.step - 1);
        this.exposeVariables();
        this.calibrateLast();
        return 2;
    }

    public void doFinally() {
        this.unExposeVariables();
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public Object getCurrent() {
        return this.item;
    }

    public LoopTagStatus getIteratorStatus() {
        if (this.status == null) {
            class Status
            implements LoopTagStatus {
                private final /* synthetic */ LoopTagSupport this$0;

                Status(LoopTagSupport this$0) {
                    this.this$0 = this$0;
                }

                public Object getCurrent() {
                    return this.this$0.getCurrent();
                }

                public int getIndex() {
                    return this.this$0.index + this.this$0.begin;
                }

                public int getCount() {
                    return this.this$0.count;
                }

                public boolean isFirst() {
                    return this.this$0.index == 0;
                }

                public boolean isLast() {
                    return this.this$0.last;
                }

                public Integer getBegin() {
                    if (this.this$0.beginSpecified) {
                        return new Integer(this.this$0.begin);
                    }
                    return null;
                }

                public Integer getEnd() {
                    if (this.this$0.endSpecified) {
                        return new Integer(this.this$0.end);
                    }
                    return null;
                }

                public Integer getStep() {
                    if (this.this$0.stepSpecified) {
                        return new Integer(this.this$0.step);
                    }
                    return null;
                }
            }
            this.status = new Status(this);
        }
        return this.status;
    }

    public void setVarStatus(String statusId) {
        this.statusId = statusId;
    }

    protected void validateBegin() throws SAXException {
        if (this.begin < 0) {
            throw new SAXException("'begin' < 0");
        }
    }

    protected void validateEnd() throws SAXException {
        if (this.end < 0) {
            throw new SAXException("'end' < 0");
        }
    }

    protected void validateStep() throws SAXException {
        if (this.step < 1) {
            throw new SAXException("'step' <= 0");
        }
    }

    private void init() {
        this.index = 0;
        this.count = 1;
        this.status = null;
        this.item = null;
        this.last = false;
        this.beginSpecified = false;
        this.endSpecified = false;
        this.stepSpecified = false;
        this.begin = 0;
        this.end = -1;
        this.step = 1;
        this.statusId = null;
    }

    private void calibrateLast() throws SAXException {
        this.last = !this.hasNext() || this.atEnd() || this.end != -1 && this.begin + this.index + this.step > this.end;
    }

    private void exposeVariables() throws SAXException {
        if (this.var != null) {
            if (this.getCurrent() == null) {
                this.removeVariable(this.var);
            } else {
                this.setVariable(this.var, this.getCurrent());
            }
        }
        if (this.statusId != null) {
            if (this.getIteratorStatus() == null) {
                this.removeVariable(this.statusId);
            } else {
                this.setVariable(this.statusId, this.getIteratorStatus());
            }
        }
    }

    private void unExposeVariables() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        if (this.var != null) {
            request.removeAttribute(this.var);
        }
        if (this.statusId != null) {
            request.removeAttribute(this.statusId);
        }
    }

    private void discard(int n) throws SAXException {
        int oldIndex = this.index;
        while (n-- > 0 && !this.atEnd() && this.hasNext()) {
            ++this.index;
            this.next();
        }
        this.index = oldIndex;
    }

    private void discardIgnoreSubset(int n) throws SAXException {
        while (n-- > 0 && this.hasNext()) {
            this.next();
        }
    }

    private boolean atEnd() {
        return this.end != -1 && this.begin + this.index >= this.end;
    }
}

