/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.lateral.LateralCacheManager;
import org.apache.jcs.auxiliary.lateral.LateralCacheNoWait;
import org.apache.jcs.auxiliary.lateral.LateralCacheRestore;

public class LateralCacheMonitor
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$lateral$LateralCacheMonitor == null ? (class$org$apache$jcs$auxiliary$lateral$LateralCacheMonitor = LateralCacheMonitor.class$("org.apache.jcs.auxiliary.lateral.LateralCacheMonitor")) : class$org$apache$jcs$auxiliary$lateral$LateralCacheMonitor));
    private static LateralCacheMonitor instance;
    private static long idlePeriod;
    private boolean alright = true;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$lateral$LateralCacheMonitor;

    public static void setIdlePeriod(long idlePeriod) {
        if (idlePeriod > LateralCacheMonitor.idlePeriod) {
            LateralCacheMonitor.idlePeriod = idlePeriod;
        }
    }

    private LateralCacheMonitor() {
    }

    static LateralCacheMonitor getInstance() {
        Class clazz = class$org$apache$jcs$auxiliary$lateral$LateralCacheMonitor == null ? (class$org$apache$jcs$auxiliary$lateral$LateralCacheMonitor = LateralCacheMonitor.class$("org.apache.jcs.auxiliary.lateral.LateralCacheMonitor")) : class$org$apache$jcs$auxiliary$lateral$LateralCacheMonitor;
        synchronized (clazz) {
            if (instance == null) {
                LateralCacheMonitor lateralCacheMonitor = instance = new LateralCacheMonitor();
                return lateralCacheMonitor;
            }
        }
        return instance;
    }

    public void notifyError() {
        this.bad();
        LateralCacheMonitor lateralCacheMonitor = this;
        synchronized (lateralCacheMonitor) {
            this.notify();
        }
    }

    public void run() {
        block12: while (true) {
            LateralCacheMonitor lateralCacheMonitor;
            if (this.alright) {
                lateralCacheMonitor = this;
                synchronized (lateralCacheMonitor) {
                    if (this.alright) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("cache monitor sleeping for " + idlePeriod));
                }
                Thread.sleep(idlePeriod);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            lateralCacheMonitor = this;
            synchronized (lateralCacheMonitor) {
                this.alright = true;
            }
            log.debug((Object)"cache monitor running.");
            log.info((Object)("LateralCacheManager.instances.size() = " + LateralCacheManager.instances.size()));
            int cnt = 0;
            Iterator itr = LateralCacheManager.instances.values().iterator();
            block13: while (true) {
                if (!itr.hasNext()) continue block12;
                ++cnt;
                LateralCacheManager mgr = (LateralCacheManager)itr.next();
                try {
                    log.info((Object)("\n " + cnt + "- mgr.lca.getTcpServer() = " + mgr.lca.getTcpServer() + " mgr = " + mgr));
                    log.info((Object)("\n " + cnt + "- mgr.caches.size() = " + mgr.caches.size()));
                    Iterator itr2 = mgr.caches.values().iterator();
                    while (true) {
                        if (!itr2.hasNext()) continue block13;
                        LateralCacheNoWait c = (LateralCacheNoWait)itr2.next();
                        if (c.getStatus() == 3) {
                            log.info((Object)("found LateralCacheNoWait in error, " + c.toString()));
                            LateralCacheRestore repairer = new LateralCacheRestore(mgr);
                            if (repairer.canFix()) {
                                repairer.fix();
                                continue;
                            }
                            this.bad();
                            continue;
                        }
                        log.info((Object)"lcnw not in error");
                    }
                }
                catch (Exception ex) {
                    this.bad();
                    log.error((Object)ex);
                }
            }
            break;
        }
    }

    private void bad() {
        if (this.alright) {
            LateralCacheMonitor lateralCacheMonitor = this;
            synchronized (lateralCacheMonitor) {
                this.alright = false;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        idlePeriod = 20000L;
    }
}

