/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.excalibur.component.ExcaliburComponentManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Recomposable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.ComponentLocatorImpl;
import org.apache.cocoon.components.DefaultSitemapConfigurationHolder;
import org.apache.cocoon.components.EnvironmentDescription;
import org.apache.cocoon.components.EnvironmentStack;
import org.apache.cocoon.components.GlobalRequestLifecycleComponent;
import org.apache.cocoon.components.ParentAware;
import org.apache.cocoon.components.RequestLifecycleComponent;
import org.apache.cocoon.components.SitemapConfigurable;
import org.apache.cocoon.components.SitemapConfigurationHolder;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.instrument.InstrumentManager;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;

public final class CocoonComponentManager
extends ExcaliburComponentManager
implements SourceResolver {
    private static final String PROCESS_KEY = CocoonComponentManager.class.getName();
    private static final String PROCESSOR_ATTR = "CocoonComponentManager.processor";
    protected static final ThreadLocal environmentStack = new ThreadLocal();
    private SourceResolver sourceResolver;
    private Map sitemapConfigurationHolders = new HashMap(15);
    private ComponentManager parentManager;
    private ArrayList parentAwareComponents = new ArrayList();
    private boolean wasDisposed;
    private InstrumentManager instrumentManager;

    public CocoonComponentManager() {
        super(null, Thread.currentThread().getContextClassLoader());
    }

    public CocoonComponentManager(ClassLoader loader) {
        super(null, loader);
    }

    public CocoonComponentManager(ComponentManager manager, ClassLoader loader) {
        super(manager, loader);
        this.setParentManager(manager);
    }

    public CocoonComponentManager(ComponentManager manager) {
        super(manager);
        this.setParentManager(manager);
    }

    protected void setParentManager(ComponentManager manager) {
        this.parentManager = manager;
        if (manager instanceof CocoonComponentManager) {
            this.setInstrumentManager(((CocoonComponentManager)manager).instrumentManager);
        }
    }

    public void setInstrumentManager(InstrumentManager iManager) {
        this.instrumentManager = iManager;
        super.setInstrumentManager(iManager);
    }

    public static void enterEnvironment(Environment env, ComponentManager manager, Processor processor) {
        if (null == env || null == manager || null == processor) {
            throw new RuntimeException("CocoonComponentManager.enterEnvironment: All parameters must be set: " + env + " - " + manager + " - " + processor);
        }
        EnvironmentStack stack = (EnvironmentStack)((Object)environmentStack.get());
        if (stack == null) {
            stack = new EnvironmentStack();
            environmentStack.set(stack);
        }
        stack.push(new EnvironmentStack.Item(env, processor, manager, stack.getOffset()));
        stack.setOffset(stack.size() - 1);
        env.setAttribute(PROCESSOR_ATTR, processor);
    }

    public static void leaveEnvironment() {
        CocoonComponentManager.leaveEnvironment(true);
    }

    public static void leaveEnvironment(boolean success) {
        EnvironmentStack stack = (EnvironmentStack)((Object)environmentStack.get());
        EnvironmentStack.Item objs = (EnvironmentStack.Item)stack.pop();
        stack.setOffset(objs.offset);
        if (stack.isEmpty()) {
            Environment env = objs.env;
            Map globalComponents = (Map)env.getAttribute(GlobalRequestLifecycleComponent.class.getName());
            if (globalComponents != null) {
                Iterator iter = globalComponents.values().iterator();
                while (iter.hasNext()) {
                    Object[] o = (Object[])iter.next();
                    Component c = (Component)o[0];
                    ((CocoonComponentManager)((Object)o[1])).releaseRLComponent(c);
                }
            }
            env.removeAttribute(GlobalRequestLifecycleComponent.class.getName());
            environmentStack.set(null);
        } else if (!success) {
            CocoonComponentManager.getCurrentEnvironment().setAttribute(PROCESSOR_ATTR, CocoonComponentManager.getCurrentProcessor());
        }
    }

    public static int markEnvironment() {
        EnvironmentStack stack = (EnvironmentStack)((Object)environmentStack.get());
        if (stack != null) {
            return stack.size();
        }
        return 0;
    }

    public static void checkEnvironment(int depth, Logger logger) throws Exception {
        int currentDepth;
        EnvironmentStack stack = (EnvironmentStack)((Object)environmentStack.get());
        int n = currentDepth = stack != null ? stack.size() : 0;
        if (currentDepth != depth) {
            logger.error("ENVIRONMENT STACK HAS NOT BEEN CLEANED PROPERLY!");
            throw new ProcessingException("Environment stack has not been cleaned up properly. Please report this (and if possible, together with a test case) to the Cocoon developers.");
        }
    }

    public static XMLConsumer createEnvironmentAwareConsumer(XMLConsumer consumer) {
        EnvironmentStack stack = (EnvironmentStack)((Object)environmentStack.get());
        EnvironmentStack.Item objs = stack.getCurrent();
        return stack.getEnvironmentAwareConsumerWrapper(consumer, objs.offset);
    }

    public static Object startProcessing(Environment env) {
        if (null == env) {
            throw new RuntimeException("CocoonComponentManager.startProcessing: environment must be set.");
        }
        EnvironmentDescription desc = new EnvironmentDescription(env);
        env.getObjectModel().put(PROCESS_KEY, desc);
        env.startingProcessing();
        return desc;
    }

    public static void endProcessing(Environment env, Object key) {
        env.finishingProcessing();
        EnvironmentDescription desc = (EnvironmentDescription)key;
        desc.release();
        env.getObjectModel().remove(PROCESS_KEY);
    }

    public static Environment getCurrentEnvironment() {
        EnvironmentStack stack = (EnvironmentStack)((Object)environmentStack.get());
        if (null != stack && !stack.isEmpty()) {
            return stack.getCurrent().env;
        }
        return null;
    }

    public static Processor getCurrentProcessor() {
        EnvironmentStack stack = (EnvironmentStack)((Object)environmentStack.get());
        if (null != stack && !stack.isEmpty()) {
            return stack.getCurrent().processor;
        }
        return null;
    }

    public static Processor getActiveProcessor(Environment env) {
        return (Processor)env.getAttribute(PROCESSOR_ATTR);
    }

    public static ComponentManager getSitemapComponentManager() {
        EnvironmentStack stack = (EnvironmentStack)((Object)environmentStack.get());
        if (null != stack && !stack.isEmpty()) {
            EnvironmentStack.Item o = (EnvironmentStack.Item)stack.peek();
            return o.manager;
        }
        return null;
    }

    public Component lookup(String role) throws ComponentException {
        EnvironmentDescription desc;
        Map objectModel;
        EnvironmentStack.Item objects;
        Component component;
        if (null == role) {
            String message = "ComponentLocator Attempted to retrieve component with null role.";
            throw new ComponentException(role, "ComponentLocator Attempted to retrieve component with null role.");
        }
        if (role.equals(SourceResolver.ROLE)) {
            if (null == this.sourceResolver) {
                if (this.wasDisposed) {
                    this.getLogger().warn("Trying to lookup SourceResolver on disposed CocoonComponentManager");
                }
                this.sourceResolver = (SourceResolver)super.lookup(role);
            }
            return this;
        }
        EnvironmentStack stack = (EnvironmentStack)((Object)environmentStack.get());
        if (null != stack && !stack.isEmpty()) {
            EnvironmentStack.Item objects2 = stack.getCurrent();
            Map objectModel2 = objects2.env.getObjectModel();
            EnvironmentDescription desc2 = (EnvironmentDescription)objectModel2.get(PROCESS_KEY);
            if (null != desc2) {
                Component component2 = desc2.getRequestLifecycleComponent(role);
                if (null != component2) {
                    return component2;
                }
                component2 = desc2.getGlobalRequestLifecycleComponent(role);
                if (null != component2) {
                    return component2;
                }
            }
        }
        if ((component = super.lookup(role)) != null && component instanceof RequestLifecycleComponent) {
            if (stack == null || stack.isEmpty()) {
                throw new ComponentException(role, "ComponentManager has no Environment Stack.");
            }
            objects = stack.getCurrent();
            objectModel = objects.env.getObjectModel();
            desc = (EnvironmentDescription)objectModel.get(PROCESS_KEY);
            if (null != desc && !desc.containsRequestLifecycleComponent(role)) {
                try {
                    if (component instanceof Recomposable) {
                        ((Recomposable)component).recompose((ComponentManager)this);
                    }
                    ((RequestLifecycleComponent)component).setup(objects.env, objectModel);
                }
                catch (Exception local) {
                    throw new ComponentException(role, "Exception during setup of RequestLifecycleComponent.", (Throwable)local);
                }
                desc.addRequestLifecycleComponent(role, component, (ComponentManager)this);
            }
        }
        if (component != null && component instanceof GlobalRequestLifecycleComponent) {
            if (stack == null || stack.isEmpty()) {
                throw new ComponentException(role, "ComponentManager has no Environment Stack.");
            }
            objects = stack.getCurrent();
            objectModel = objects.env.getObjectModel();
            desc = (EnvironmentDescription)objectModel.get(PROCESS_KEY);
            if (null != desc && !desc.containsGlobalRequestLifecycleComponent(role)) {
                try {
                    if (component instanceof Recomposable) {
                        ((Recomposable)component).recompose((ComponentManager)this);
                    }
                    ((GlobalRequestLifecycleComponent)component).setup(objects.env, objectModel);
                }
                catch (Exception local) {
                    throw new ComponentException(role, "Exception during setup of RequestLifecycleComponent.", (Throwable)local);
                }
                desc.addGlobalRequestLifecycleComponent(role, component, (ComponentManager)this);
            }
        }
        if (component != null && component instanceof SitemapConfigurable) {
            SitemapConfigurationHolder holder = (SitemapConfigurationHolder)this.sitemapConfigurationHolders.get(role);
            if (null == holder) {
                holder = new DefaultSitemapConfigurationHolder(role);
                this.sitemapConfigurationHolders.put(role, holder);
            }
            try {
                ((SitemapConfigurable)component).configure(holder);
            }
            catch (ConfigurationException ce) {
                throw new ComponentException(role, "Exception during setup of SitemapConfigurable.", (Throwable)ce);
            }
        }
        return component;
    }

    public void release(Component component) {
        if (null == component) {
            return;
        }
        if (component instanceof RequestLifecycleComponent || component instanceof GlobalRequestLifecycleComponent) {
            return;
        }
        if (component == this) {
            return;
        }
        super.release(component);
    }

    protected void releaseRLComponent(Component component) {
        super.release(component);
    }

    public static void addComponentForAutomaticRelease(ComponentSelector selector, Component component, ComponentManager manager) throws ProcessingException {
        EnvironmentStack stack = (EnvironmentStack)((Object)environmentStack.get());
        if (null != stack && !stack.isEmpty()) {
            EnvironmentStack.Item objects = (EnvironmentStack.Item)stack.get(0);
            Map objectModel = objects.env.getObjectModel();
            EnvironmentDescription desc = (EnvironmentDescription)objectModel.get(PROCESS_KEY);
            if (null != desc) {
                desc.addToAutoRelease(selector, component, manager);
            }
        } else {
            throw new ProcessingException("Unable to add component for automatic release: no environment available.");
        }
    }

    public static void addComponentForAutomaticRelease(ComponentManager manager, Component component) throws ProcessingException {
        EnvironmentStack stack = (EnvironmentStack)((Object)environmentStack.get());
        if (null != stack && !stack.isEmpty()) {
            EnvironmentStack.Item objects = (EnvironmentStack.Item)stack.get(0);
            Map objectModel = objects.env.getObjectModel();
            EnvironmentDescription desc = (EnvironmentDescription)objectModel.get(PROCESS_KEY);
            if (null != desc) {
                desc.addToAutoRelease(manager, component);
            }
        } else {
            throw new ProcessingException("Unable to add component for automatic release: no environment available.");
        }
    }

    public static void removeFromAutomaticRelease(Component component) throws ProcessingException {
        EnvironmentStack stack = (EnvironmentStack)((Object)environmentStack.get());
        if (null != stack && !stack.isEmpty()) {
            EnvironmentStack.Item objects = (EnvironmentStack.Item)stack.get(0);
            Map objectModel = objects.env.getObjectModel();
            EnvironmentDescription desc = (EnvironmentDescription)objectModel.get(PROCESS_KEY);
            if (null != desc) {
                desc.removeFromAutoRelease(component);
            }
        } else {
            throw new ProcessingException("Unable to remove component from automatic release: no environment available.");
        }
    }

    public void dispose() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("CocoonComponentManager.dispose() called");
        }
        if (null != this.sourceResolver) {
            super.release((Component)this.sourceResolver);
        }
        super.dispose();
        this.sourceResolver = null;
        this.wasDisposed = true;
    }

    public Source resolveURI(String location) throws MalformedURLException, IOException, SourceException {
        return this.resolveURI(location, null, null);
    }

    public Source resolveURI(String location, String baseURI, Map parameters) throws MalformedURLException, IOException, SourceException {
        EnvironmentStack stack;
        if (baseURI == null && null != (stack = (EnvironmentStack)((Object)environmentStack.get())) && !stack.isEmpty()) {
            EnvironmentStack.Item objects = stack.getCurrent();
            baseURI = objects.env.getContext();
        }
        return this.sourceResolver.resolveURI(location, baseURI, parameters);
    }

    public void release(Source source) {
        this.sourceResolver.release(source);
    }

    public void addComponent(String role, Class clazz, Configuration conf) throws ComponentException {
        super.addComponent(role, clazz, conf);
        if (ParentAware.class.isAssignableFrom(clazz)) {
            this.parentAwareComponents.add(role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws Exception {
        super.initialize();
        if (this.parentAwareComponents == null) {
            throw new ComponentException(null, "CocoonComponentManager already initialized");
        }
        Iterator iter = this.parentAwareComponents.iterator();
        while (iter.hasNext()) {
            String role = (String)iter.next();
            this.getLogger().debug(".. " + role);
            if (this.parentManager == null || !this.parentManager.hasComponent(role)) continue;
            Component component = null;
            try {
                component = this.lookup(role);
                ((ParentAware)component).setParentLocator(new ComponentLocatorImpl(this.parentManager, role));
            }
            catch (ComponentException ignore) {}
            continue;
            finally {
                this.release(component);
            }
        }
        this.parentAwareComponents = null;
    }

    public static abstract class AbstractCocoonRunnable
    implements Runnable {
        private Object parentStack = null;

        public AbstractCocoonRunnable() {
            Object stack = environmentStack.get();
            if (stack != null) {
                this.parentStack = ((EnvironmentStack)((Object)stack)).clone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            Object oldStack = environmentStack.get();
            environmentStack.set(this.parentStack);
            try {
                this.doRun();
            }
            finally {
                environmentStack.set(oldStack);
            }
        }

        protected abstract void doRun();
    }
}

