/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.profile.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.coplet.CopletFactory;
import org.apache.cocoon.portal.coplet.CopletInstanceData;
import org.apache.cocoon.portal.coplet.adapter.CopletAdapter;
import org.apache.cocoon.portal.layout.Layout;
import org.apache.cocoon.portal.layout.LayoutFactory;
import org.apache.cocoon.portal.profile.ProfileLS;
import org.apache.cocoon.portal.profile.impl.AbstractUserProfileManager;
import org.apache.cocoon.portal.profile.impl.CopletBaseDataManager;
import org.apache.cocoon.portal.profile.impl.CopletDataManager;
import org.apache.cocoon.portal.profile.impl.CopletInstanceDataManager;
import org.apache.cocoon.portal.util.DeltaApplicableReferencesAdjustable;
import org.apache.cocoon.portal.util.ProfileException;
import org.apache.cocoon.webapps.authentication.AuthenticationManager;
import org.apache.cocoon.webapps.authentication.configuration.ApplicationConfiguration;
import org.apache.cocoon.webapps.authentication.user.RequestState;
import org.apache.cocoon.webapps.authentication.user.UserHandler;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceValidity;

public class AuthenticationProfileManager
extends AbstractUserProfileManager {
    protected ReadWriteLock lock = new ReadWriteLock();
    protected Map attributes = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RequestState getRequestState() {
        RequestState requestState;
        AuthenticationManager authManager = null;
        try {
            authManager = (AuthenticationManager)this.manager.lookup(AuthenticationManager.ROLE);
            requestState = authManager.getState();
            Object var5_4 = null;
        }
        catch (ServiceException ce) {
            RequestState requestState2;
            try {
                requestState2 = null;
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.manager.release((Object)authManager);
                throw throwable;
            }
            this.manager.release((Object)authManager);
            return requestState2;
        }
        this.manager.release((Object)authManager);
        return requestState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Layout loadProfile(String layoutKey, PortalService service, CopletFactory copletFactory, LayoutFactory layoutFactory, ServiceSelector adapterSelector) throws Exception {
        RequestState state = this.getRequestState();
        UserHandler handler = state.getHandler();
        ApplicationConfiguration ac = state.getApplicationConfiguration();
        if (ac == null) {
            throw new ProcessingException("Configuration for portal not found in application configuration.");
        }
        Configuration appConf = ac.getConfiguration("portal");
        if (appConf == null) {
            throw new ProcessingException("Configuration for portal not found in application configuration.");
        }
        Configuration config = appConf.getChild("profiles");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("config", config);
        parameters.put("handler", handler);
        CopletDataManager copletDataManager = null;
        try {
            this.lock.readLock();
            parameters.put("profiletype", "copletbasedata");
            parameters.put("objectmap", null);
            Object[] result = this.getProfile(layoutKey, parameters, null, false, service);
            CopletBaseDataManager copletBaseDataManager = (CopletBaseDataManager)result[0];
            parameters.put("profiletype", "copletdata");
            parameters.put("objectmap", copletBaseDataManager.getCopletBaseData());
            copletDataManager = (CopletDataManager)this.getDeltaProfile(layoutKey, parameters, service, copletFactory, (Boolean)result[1]);
            Object var16_15 = null;
            this.lock.releaseLocks();
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            this.lock.releaseLocks();
            throw throwable;
        }
        parameters.put("profiletype", "copletinstancedata");
        parameters.put("objectmap", copletDataManager.getCopletData());
        CopletInstanceDataManager copletInstanceDataManager = (CopletInstanceDataManager)this.getOrCreateProfile(layoutKey, parameters, service, copletFactory);
        service.setAttribute("CopletInstanceData:" + layoutKey, copletInstanceDataManager);
        parameters.put("profiletype", "layout");
        parameters.put("objectmap", copletInstanceDataManager.getCopletInstanceData());
        Layout layout = (Layout)this.getOrCreateProfile(layoutKey, parameters, service, layoutFactory);
        service.setAttribute("Layout:" + layoutKey, layout);
        Iterator iter = copletInstanceDataManager.getCopletInstanceData().values().iterator();
        while (iter.hasNext()) {
            Object var19_20;
            CopletInstanceData cid = (CopletInstanceData)iter.next();
            CopletAdapter adapter = null;
            try {
                adapter = (CopletAdapter)adapterSelector.select((Object)cid.getCopletData().getCopletBaseData().getCopletAdapterName());
                adapter.login(cid);
                var19_20 = null;
            }
            catch (Throwable throwable) {
                var19_20 = null;
                adapterSelector.release((Object)adapter);
                throw throwable;
            }
            adapterSelector.release((Object)adapter);
            {
            }
        }
        return layout;
    }

    public void saveUserProfiles() {
        String layoutKey = this.getDefaultLayoutKey();
        ProfileLS adapter = null;
        PortalService service = null;
        try {
            try {
                adapter = (ProfileLS)this.manager.lookup(ProfileLS.ROLE);
                service = (PortalService)this.manager.lookup(PortalService.ROLE);
                RequestState state = this.getRequestState();
                UserHandler handler = state.getHandler();
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("type", "user");
                parameters.put("config", (String)state.getApplicationConfiguration().getConfiguration("portal").getChild("profiles"));
                parameters.put("handler", (String)handler);
                parameters.put("profiletype", "copletinstancedata");
                Map key = this.buildKey(service, parameters, layoutKey, false);
                CopletInstanceDataManager profileManager = (CopletInstanceDataManager)service.getAttribute("CopletInstanceData:" + layoutKey);
                adapter.saveProfile(key, parameters, profileManager);
                parameters.put("profiletype", "layout");
                key = this.buildKey(service, parameters, layoutKey, false);
                Layout layout = (Layout)service.getAttribute("Layout:" + layoutKey);
                adapter.saveProfile(key, parameters, layout);
            }
            catch (Exception e) {
                throw new CascadingRuntimeException("Exception during save profile", (Throwable)e);
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.manager.release((Object)adapter);
            this.manager.release((Object)service);
            throw throwable;
        }
        this.manager.release((Object)adapter);
        this.manager.release((Object)service);
    }

    protected Object getDeltaProfile(String layoutKey, Map parameters, PortalService service, Object factory, boolean forcedLoad) throws Exception {
        DeltaApplicableReferencesAdjustable result;
        Map key;
        Object global;
        block8: {
            Object object;
            block7: {
                parameters.put("type", "global");
                global = this.getProfile(layoutKey, parameters, factory, forcedLoad, service)[0];
                key = this.buildKey(service, parameters, layoutKey, true);
                result = (DeltaApplicableReferencesAdjustable)this.loadProfile(key, parameters, factory);
                parameters.put("type", "role");
                try {
                    object = this.getProfile(layoutKey, parameters, factory, forcedLoad, service)[0];
                    if (object != null) {
                        result.applyDelta(object);
                    }
                }
                catch (Exception e) {
                    if (this.isSourceNotFoundException(e)) break block7;
                    throw e;
                }
            }
            parameters.put("type", "user");
            try {
                key = this.buildKey(service, parameters, layoutKey, true);
                object = this.loadProfile(key, parameters, factory);
                if (object != null) {
                    result.applyDelta(object);
                }
            }
            catch (Exception e) {
                if (this.isSourceNotFoundException(e)) break block8;
                throw e;
            }
        }
        if (result == null) {
            throw new SourceNotFoundException("Global profile does not exist.");
        }
        result.adjustReferences(global);
        this.attributes.put(key, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getOrCreateProfile(String layoutKey, Map parameters, PortalService service, Object factory) throws Exception {
        Object result;
        parameters.put("type", "user");
        Map keyMap = this.buildKey(service, parameters, layoutKey, true);
        try {
            result = this.loadProfile(keyMap, parameters, factory);
        }
        catch (Exception e1) {
            if (!this.isSourceNotFoundException(e1)) {
                throw e1;
            }
            parameters.put("type", "role");
            keyMap = this.buildKey(service, parameters, layoutKey, true);
            try {
                result = this.loadProfile(keyMap, parameters, factory);
            }
            catch (Exception e2) {
                if (!this.isSourceNotFoundException(e2)) {
                    throw e2;
                }
                parameters.put("type", "global");
                keyMap = this.buildKey(service, parameters, layoutKey, true);
                result = this.loadProfile(keyMap, parameters, factory);
            }
            ProfileLS adapter = null;
            try {
                adapter = (ProfileLS)this.manager.lookup(ProfileLS.ROLE);
                parameters.put("type", "user");
                keyMap = this.buildKey(service, parameters, layoutKey, false);
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                this.manager.release((Object)adapter);
                throw throwable;
            }
            this.manager.release((Object)adapter);
            {
            }
        }
        this.attributes.put(keyMap, result);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object[] getProfile(String layoutKey, Map parameters, Object factory, boolean forcedLoad, PortalService service) throws Exception {
        Object[] objectArray;
        ProfileLS adapter;
        block11: {
            Object[] objectArray2;
            block10: {
                Object[] objectArray3;
                block9: {
                    Map key = this.buildKey(service, parameters, layoutKey, true);
                    adapter = null;
                    try {
                        try {
                            adapter = (ProfileLS)this.manager.lookup(ProfileLS.ROLE);
                            Object result = this.checkValidity(key, parameters, forcedLoad, adapter);
                            if (!(result instanceof SourceValidity)) {
                                objectArray3 = new Object[]{result, Boolean.FALSE};
                                Object var15_12 = null;
                                break block9;
                            }
                            SourceValidity newValidity = (SourceValidity)result;
                            this.lock.releaseReadLock();
                            this.lock.writeLock();
                            result = this.checkValidity(key, parameters, forcedLoad, adapter);
                            if (!(result instanceof SourceValidity)) {
                                objectArray2 = new Object[]{result, Boolean.FALSE};
                                break block10;
                            }
                            newValidity = (SourceValidity)result;
                            Object object = adapter.loadProfile(key, parameters);
                            this.prepareObject(object, factory);
                            if (newValidity != null) {
                                this.attributes.put(key, new Object[]{object, newValidity});
                            }
                            objectArray = new Object[]{object, Boolean.TRUE};
                            break block11;
                        }
                        catch (ProfileException pe) {
                            this.getLogger().error("Error loading profile: " + pe.getMessage(), (Throwable)pe);
                            throw pe;
                        }
                        catch (Exception t) {
                            this.getLogger().error("Error loading profile.", (Throwable)t);
                            throw t;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var15_15 = null;
                        this.manager.release((Object)adapter);
                        throw throwable;
                    }
                }
                this.manager.release((Object)adapter);
                return objectArray3;
            }
            Object var15_13 = null;
            this.manager.release((Object)adapter);
            return objectArray2;
        }
        Object var15_14 = null;
        this.manager.release((Object)adapter);
        return objectArray;
    }

    protected Object checkValidity(Object key, Map parameters, boolean forcedLoad, ProfileLS adapter) {
        Object[] objects = (Object[])this.attributes.get(key);
        SourceValidity sourceValidity = null;
        int valid = -1;
        if (objects != null) {
            sourceValidity = (SourceValidity)objects[1];
            valid = sourceValidity.isValid();
            if (!forcedLoad && valid == 1) {
                return objects[0];
            }
        }
        SourceValidity newValidity = adapter.getValidity(key, parameters);
        if (!forcedLoad && valid == 0 && sourceValidity.isValid(newValidity) == 1) {
            return objects[0];
        }
        return newValidity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object loadProfile(Object key, Map map, Object factory) throws Exception {
        Object object;
        ProfileLS adapter = null;
        try {
            adapter = (ProfileLS)this.manager.lookup(ProfileLS.ROLE);
            Object object2 = adapter.loadProfile(key, map);
            this.prepareObject(object2, factory);
            object = object2;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.manager.release((Object)adapter);
            throw throwable;
        }
        this.manager.release((Object)adapter);
        return object;
    }

    private boolean isSourceNotFoundException(Throwable t) {
        while (t != null) {
            if (t instanceof SourceNotFoundException) {
                return true;
            }
            t = ExceptionUtils.getCause((Throwable)t);
        }
        return false;
    }

    protected Map buildKey(PortalService service, Map parameters, String layoutKey, boolean load) throws ProcessingException, ConfigurationException {
        String type = (String)parameters.get("type");
        Configuration config = (Configuration)parameters.get("config");
        String profileType = (String)parameters.get("profiletype");
        String postFix = load ? "load" : "save";
        UserHandler handler = (UserHandler)parameters.get("handler");
        String uri = null;
        if (type == null) {
            uri = config.getChild(profileType + "-" + postFix).getAttribute("uri");
        } else if (type.equals("global")) {
            uri = config.getChild(profileType + "-global-" + postFix).getAttribute("uri");
        } else if (type.equals("role")) {
            uri = config.getChild(profileType + "-role-" + postFix).getAttribute("uri");
        } else if (type.equals("user")) {
            uri = config.getChild(profileType + "-user-" + postFix).getAttribute("uri");
        }
        LinkedMap key = new LinkedMap();
        key.put("baseuri", uri);
        key.put("separator", "?");
        key.put("portal", service.getPortalName());
        key.put("layout", layoutKey);
        if (type != null) {
            key.put("type", type);
            if ("role".equals(type) || "user".equals(type)) {
                key.put("role", handler.getContext().getContextInfo().get("role"));
            }
            if ("user".equals(type)) {
                key.put("user", handler.getUserId());
            }
        }
        return key;
    }

    class ReadWriteLock {
        private Thread activeWriter = null;
        private HashSet activeReaders = new HashSet();
        private int waitingWriters = 0;

        ReadWriteLock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readLock() throws InterruptedException {
            ReadWriteLock readWriteLock = this;
            synchronized (readWriteLock) {
                while (this.activeWriter != null || this.waitingWriters != 0) {
                    this.wait();
                }
                this.activeReaders.add(Thread.currentThread());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeLock() throws InterruptedException {
            ReadWriteLock readWriteLock = this;
            synchronized (readWriteLock) {
                Thread current = Thread.currentThread();
                if (this.activeWriter != current) {
                    ++this.waitingWriters;
                    while (this.activeWriter != null || this.activeReaders.size() != 0) {
                        this.wait();
                    }
                    --this.waitingWriters;
                    this.activeWriter = current;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseReadLock() {
            ReadWriteLock readWriteLock = this;
            synchronized (readWriteLock) {
                Thread current = Thread.currentThread();
                this.activeReaders.remove(current);
                if (this.activeReaders.size() == 0 && this.waitingWriters > 0) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseLocks() {
            ReadWriteLock readWriteLock = this;
            synchronized (readWriteLock) {
                Thread current = Thread.currentThread();
                boolean notify = false;
                if (this.activeWriter == current) {
                    this.activeWriter = null;
                    notify = true;
                }
                this.activeReaders.remove(current);
                if (this.activeReaders.size() == 0 && this.waitingWriters > 0) {
                    notify = true;
                }
                if (notify) {
                    this.notifyAll();
                }
            }
        }
    }
}

