/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.CompareToIntegerConstant;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.IdentityComparison;
import net.sf.saxon.expr.IsLastExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PositionRange;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Aggregate;
import net.sf.saxon.functions.Last;
import net.sf.saxon.functions.NamePart;
import net.sf.saxon.functions.Position;
import net.sf.saxon.functions.StringLength;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.GenericAtomicComparer;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class ValueComparison
extends BinaryExpression
implements ComparisonExpression {
    private AtomicComparer comparer;
    private BooleanValue resultWhenEmpty = null;
    private boolean operand0MaybeUntyped = true;
    private boolean operand1MaybeUntyped = true;

    public ValueComparison(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.resultWhenEmpty != null) {
            this.resultWhenEmpty = this.resultWhenEmpty.getBooleanValue() ? BooleanValue.TRUE : BooleanValue.FALSE;
        }
    }

    public AtomicComparer getAtomicComparer() {
        return this.comparer;
    }

    public int getSingletonOperator() {
        return this.operator;
    }

    public boolean convertsUntypedToOther() {
        return false;
    }

    public void setResultWhenEmpty(BooleanValue booleanValue) {
        this.resultWhenEmpty = booleanValue;
    }

    public BooleanValue getResultWhenEmpty() {
        return this.resultWhenEmpty;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        String string;
        StringCollator stringCollator;
        BuiltInAtomicType builtInAtomicType;
        this.operand0 = this.operand0.typeCheck(staticContext, itemType);
        if (Literal.isEmptySequence(this.operand0)) {
            return this.resultWhenEmpty == null ? this.operand0 : Literal.makeLiteral(this.resultWhenEmpty);
        }
        this.operand1 = this.operand1.typeCheck(staticContext, itemType);
        if (Literal.isEmptySequence(this.operand1)) {
            return this.resultWhenEmpty == null ? this.operand1 : Literal.makeLiteral(this.resultWhenEmpty);
        }
        SequenceType sequenceType = SequenceType.OPTIONAL_ATOMIC;
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        RoleLocator roleLocator = new RoleLocator(1, Token.tokens[this.operator], 0, null);
        roleLocator.setSourceLocator(this);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, sequenceType, false, roleLocator, staticContext);
        RoleLocator roleLocator2 = new RoleLocator(1, Token.tokens[this.operator], 1, null);
        roleLocator2.setSourceLocator(this);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, sequenceType, false, roleLocator2, staticContext);
        AtomicType atomicType = this.operand0.getItemType(typeHierarchy).getAtomizedItemType();
        AtomicType atomicType2 = this.operand1.getItemType(typeHierarchy).getAtomizedItemType();
        if (atomicType.isExternalType() || atomicType2.isExternalType()) {
            StaticError staticError = new StaticError("Cannot perform comparisons involving external objects");
            staticError.setIsTypeError(true);
            staticError.setErrorCode("XPTY0004");
            staticError.setLocator(this);
            throw staticError;
        }
        BuiltInAtomicType builtInAtomicType2 = (BuiltInAtomicType)atomicType.getPrimitiveItemType();
        if (builtInAtomicType2.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            builtInAtomicType2 = BuiltInAtomicType.STRING;
        }
        if ((builtInAtomicType = (BuiltInAtomicType)atomicType2.getPrimitiveItemType()).equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            builtInAtomicType = BuiltInAtomicType.STRING;
        }
        this.operand0MaybeUntyped = typeHierarchy.relationship(builtInAtomicType2, BuiltInAtomicType.UNTYPED_ATOMIC) != 4;
        boolean bl = this.operand1MaybeUntyped = typeHierarchy.relationship(builtInAtomicType, BuiltInAtomicType.UNTYPED_ATOMIC) != 4;
        if (!Type.isComparable(builtInAtomicType2, builtInAtomicType, Token.isOrderedOperator(this.operator))) {
            boolean bl2 = Cardinality.allowsZero(this.operand0.getCardinality());
            boolean bl3 = Cardinality.allowsZero(this.operand1.getCardinality());
            if (bl2 || bl3) {
                String string2 = null;
                if (bl2) {
                    string2 = "the first operand is";
                }
                if (bl3) {
                    string2 = "the second operand is";
                }
                if (bl2 && bl3) {
                    string2 = "one or both operands are";
                }
                staticContext.issueWarning("Comparison of " + atomicType.toString(staticContext.getNamePool()) + (bl2 ? "?" : "") + " to " + atomicType2.toString(staticContext.getNamePool()) + (bl3 ? "?" : "") + " will fail unless " + string2 + " empty", this);
            } else {
                StaticError staticError = new StaticError("Cannot compare " + atomicType.toString(staticContext.getNamePool()) + " to " + atomicType2.toString(staticContext.getNamePool()));
                staticError.setIsTypeError(true);
                staticError.setErrorCode("XPTY0004");
                staticError.setLocator(this);
                throw staticError;
            }
        }
        if (this.operator != 44 && this.operator != 45) {
            if (!builtInAtomicType2.isOrdered()) {
                StaticError staticError = new StaticError("Type " + atomicType.toString(staticContext.getNamePool()) + " is not an ordered type");
                staticError.setErrorCode("XPTY0004");
                staticError.setIsTypeError(true);
                staticError.setLocator(this);
                throw staticError;
            }
            if (!builtInAtomicType.isOrdered()) {
                StaticError staticError = new StaticError("Type " + atomicType2.toString(staticContext.getNamePool()) + " is not an ordered type");
                staticError.setErrorCode("XPTY0004");
                staticError.setIsTypeError(true);
                staticError.setLocator(this);
                throw staticError;
            }
        }
        if ((stringCollator = staticContext.getCollation(string = staticContext.getDefaultCollationName())) == null) {
            stringCollator = CodepointCollator.getInstance();
        }
        this.comparer = GenericAtomicComparer.makeAtomicComparer(builtInAtomicType2, builtInAtomicType, stringCollator, staticContext.getConfiguration());
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        int n;
        int n2;
        this.operand0 = this.operand0.optimize(optimizer, staticContext, itemType);
        this.operand1 = this.operand1.optimize(optimizer, staticContext, itemType);
        Value value = null;
        Value value2 = null;
        if (this.operand0 instanceof Literal) {
            value = ((Literal)this.operand0).getValue();
        }
        if (this.operand1 instanceof Literal) {
            value2 = ((Literal)this.operand1).getValue();
        }
        if (value != null && value2 != null) {
            AtomicValue atomicValue = (AtomicValue)this.evaluateItem(staticContext.makeEarlyEvaluationContext());
            return Literal.makeLiteral(atomicValue == null ? EmptySequence.getInstance() : atomicValue);
        }
        if (Aggregate.isCountFunction(this.operand0) && Literal.isAtomic(this.operand1)) {
            if (ValueComparison.isZero(value2)) {
                if (this.operator == 44 || this.operator == 49) {
                    FunctionCall functionCall = SystemFunction.makeSystemFunction("empty", 1, staticContext.getNamePool());
                    Expression[] expressionArray = new Expression[]{((FunctionCall)this.operand0).argument[0]};
                    functionCall.setArguments(expressionArray);
                    functionCall.setParentExpression(this.getParentExpression());
                    return functionCall;
                }
                if (this.operator == 45 || this.operator == 46) {
                    FunctionCall functionCall = SystemFunction.makeSystemFunction("exists", 1, staticContext.getNamePool());
                    Expression[] expressionArray = new Expression[]{ExpressionTool.unsorted(optimizer, ((FunctionCall)this.operand0).argument[0], false)};
                    functionCall.setArguments(expressionArray);
                    functionCall.setParentExpression(this.getParentExpression());
                    return functionCall;
                }
                if (this.operator == 48) {
                    return Literal.makeLiteral(BooleanValue.TRUE);
                }
                return Literal.makeLiteral(BooleanValue.FALSE);
            }
            if (value2 instanceof Int64Value && (this.operator == 46 || this.operator == 48)) {
                long l = ((Int64Value)value2).longValue();
                if (this.operator == 46) {
                    ++l;
                }
                FunctionCall functionCall = SystemFunction.makeSystemFunction("exists", 1, staticContext.getNamePool());
                Expression[] expressionArray = new Expression[1];
                FilterExpression filterExpression = new FilterExpression(((FunctionCall)this.operand0).argument[0], Literal.makeLiteral(Int64Value.makeIntegerValue(l)));
                expressionArray[0] = filterExpression;
                functionCall.setArguments(expressionArray);
                functionCall.setParentExpression(this.getParentExpression());
                return functionCall;
            }
        }
        if (Aggregate.isCountFunction(this.operand1) && ValueComparison.isZero(value)) {
            ValueComparison valueComparison = new ValueComparison(this.operand1, Token.inverse(this.operator), this.operand0);
            valueComparison.setParentExpression(this.getParentExpression());
            return valueComparison.typeCheck(staticContext, itemType).optimize(optimizer, staticContext, itemType);
        }
        if (this.operand0 instanceof StringLength && ((StringLength)this.operand0).getNumberOfArguments() == 1 && ValueComparison.isZero(value2)) {
            ((StringLength)this.operand0).setShortcut();
        }
        if (this.operand1 instanceof StringLength && ((StringLength)this.operand1).getNumberOfArguments() == 1 && ValueComparison.isZero(value)) {
            ((StringLength)this.operand1).setShortcut();
        }
        if (this.operand0 instanceof Position && this.operand1 instanceof Last) {
            switch (this.operator) {
                case 44: 
                case 48: {
                    IsLastExpression isLastExpression = new IsLastExpression(true);
                    isLastExpression.setParentExpression(this.getParentExpression());
                    isLastExpression.setLocationId(this.getLocationId());
                    return isLastExpression;
                }
                case 45: 
                case 47: {
                    IsLastExpression isLastExpression = new IsLastExpression(false);
                    isLastExpression.setParentExpression(this.getParentExpression());
                    isLastExpression.setLocationId(this.getLocationId());
                    return isLastExpression;
                }
                case 46: {
                    return Literal.makeLiteral(BooleanValue.FALSE);
                }
                case 49: {
                    return Literal.makeLiteral(BooleanValue.TRUE);
                }
            }
        }
        if (this.operand0 instanceof Last && this.operand1 instanceof Position) {
            switch (this.operator) {
                case 44: 
                case 49: {
                    IsLastExpression isLastExpression = new IsLastExpression(true);
                    isLastExpression.setParentExpression(this.getParentExpression());
                    isLastExpression.setLocationId(this.getLocationId());
                    return isLastExpression;
                }
                case 45: 
                case 46: {
                    IsLastExpression isLastExpression = new IsLastExpression(false);
                    isLastExpression.setParentExpression(this.getParentExpression());
                    isLastExpression.setLocationId(this.getLocationId());
                    return isLastExpression;
                }
                case 47: {
                    return Literal.makeLiteral(BooleanValue.FALSE);
                }
                case 48: {
                    return Literal.makeLiteral(BooleanValue.TRUE);
                }
            }
        }
        if (this.operand0 instanceof Position) {
            n2 = value2 instanceof Int64Value;
            n = 0;
            if (n2 != 0 && (n = (int)((Int64Value)value2).longValue()) < 0) {
                n = 0;
            }
            switch (this.operator) {
                case 44: {
                    return this.makePositionRange(this.operand1);
                }
                case 48: {
                    return this.makeOpenPositionRange(this.operand1);
                }
                case 45: {
                    if (n2 == 0 || n != 1) break;
                    return this.makePositionRange(2, Integer.MAX_VALUE);
                }
                case 47: {
                    if (n2 == 0) break;
                    return this.makePositionRange(1, n - 1);
                }
                case 46: {
                    if (n2 == 0) break;
                    return this.makePositionRange(n + 1, Integer.MAX_VALUE);
                }
                case 49: {
                    if (n2 == 0) break;
                    return this.makePositionRange(1, n);
                }
            }
        }
        if (this.operand1 instanceof Position) {
            n2 = 0;
            n = value instanceof Int64Value;
            if (n != 0 && (n2 = (int)((Int64Value)value).longValue()) < 0) {
                n2 = 0;
            }
            switch (this.operator) {
                case 44: {
                    return this.makePositionRange(this.operand0);
                }
                case 49: {
                    return this.makeOpenPositionRange(this.operand0);
                }
                case 45: {
                    if (n == 0 || n2 != 1) break;
                    return this.makePositionRange(2, Integer.MAX_VALUE);
                }
                case 46: {
                    if (n == 0) break;
                    return this.makePositionRange(1, n2 - 1);
                }
                case 47: {
                    if (n == 0) break;
                    return this.makePositionRange(n2 + 1, Integer.MAX_VALUE);
                }
                case 48: {
                    if (n == 0) break;
                    return this.makePositionRange(1, n2);
                }
            }
        }
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        if (value2 instanceof Int64Value && this.operand0.getCardinality() == 16384 && typeHierarchy.isSubType(this.operand0.getItemType(typeHierarchy), BuiltInAtomicType.NUMERIC)) {
            return new CompareToIntegerConstant(this.operand0, this.operator, ((Int64Value)value2).longValue());
        }
        if (value instanceof Int64Value && this.operand1.getCardinality() == 16384 && typeHierarchy.isSubType(this.operand1.getItemType(typeHierarchy), BuiltInAtomicType.NUMERIC)) {
            return new CompareToIntegerConstant(this.operand1, Token.inverse(this.operator), ((Int64Value)value).longValue());
        }
        if (NamePart.isGenerateIdFunction(this.operand0) && NamePart.isGenerateIdFunction(this.operand1)) {
            FunctionCall functionCall = (FunctionCall)this.operand0;
            FunctionCall functionCall2 = (FunctionCall)this.operand1;
            if (!Cardinality.allowsMany(functionCall.argument[0].getCardinality()) && !Cardinality.allowsMany(functionCall2.argument[0].getCardinality()) && this.operator == 44) {
                IdentityComparison identityComparison = new IdentityComparison(functionCall.argument[0], 20, functionCall2.argument[0]);
                identityComparison.setGenerateIdEmulation(true);
                identityComparison.setLocationId(this.getLocationId());
                identityComparison.setParentExpression(this.getParentExpression());
                return identityComparison.simplify(staticContext).typeCheck(staticContext, itemType).optimize(optimizer, staticContext, itemType);
            }
        }
        return this;
    }

    private PositionRange makePositionRange(int n, int n2) {
        PositionRange positionRange = new PositionRange(n, n2);
        positionRange.setParentExpression(this.getParentExpression());
        positionRange.setLocationId(this.getLocationId());
        return positionRange;
    }

    private PositionRange makeOpenPositionRange(Expression expression) {
        PositionRange positionRange = new PositionRange(expression, null);
        positionRange.setParentExpression(this.getParentExpression());
        positionRange.setLocationId(this.getLocationId());
        return positionRange;
    }

    private Expression makePositionRange(Expression expression) {
        if (expression instanceof Position) {
            return Literal.makeLiteral(BooleanValue.TRUE);
        }
        if ((expression.getDependencies() & 6) != 0) {
            return this;
        }
        PositionRange positionRange = new PositionRange(expression);
        positionRange.setParentExpression(this.getParentExpression());
        positionRange.setLocationId(this.getLocationId());
        return positionRange;
    }

    public ValueComparison negate() {
        ValueComparison valueComparison = new ValueComparison(this.operand0, Token.negate(this.operator), this.operand1);
        valueComparison.comparer = this.comparer;
        valueComparison.resultWhenEmpty = this.resultWhenEmpty == null || this.resultWhenEmpty == BooleanValue.FALSE ? BooleanValue.TRUE : BooleanValue.FALSE;
        valueComparison.setLocationId(this.getLocationId());
        return valueComparison;
    }

    private static boolean isZero(Value value) {
        if (value instanceof NumericValue) {
            return ((NumericValue)value).compareTo(0L) == 0;
        }
        return false;
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        try {
            AtomicValue atomicValue;
            AtomicValue atomicValue2 = (AtomicValue)this.operand0.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return this.resultWhenEmpty == BooleanValue.TRUE;
            }
            if (this.operand0MaybeUntyped && atomicValue2 instanceof UntypedAtomicValue) {
                atomicValue2 = new StringValue(((UntypedAtomicValue)atomicValue2).getStringValueCS());
            }
            if ((atomicValue = (AtomicValue)this.operand1.evaluateItem(xPathContext)) == null) {
                return this.resultWhenEmpty == BooleanValue.TRUE;
            }
            if (this.operand1MaybeUntyped && atomicValue instanceof UntypedAtomicValue) {
                atomicValue = new StringValue(((UntypedAtomicValue)atomicValue).getStringValueCS());
            }
            return ValueComparison.compare(atomicValue2, this.operator, atomicValue, this.comparer);
        }
        catch (DynamicError dynamicError) {
            if (dynamicError.getXPathContext() == null) {
                dynamicError.setXPathContext(xPathContext);
            }
            if (dynamicError.getLocator() == null) {
                dynamicError.setLocator(this);
            }
            throw dynamicError;
        }
    }

    static boolean compare(AtomicValue atomicValue, int n, AtomicValue atomicValue2, AtomicComparer atomicComparer) throws DynamicError {
        if (atomicValue instanceof NumericValue && ((NumericValue)atomicValue).isNaN()) {
            return n == 45;
        }
        if (atomicValue2 instanceof NumericValue && ((NumericValue)atomicValue2).isNaN()) {
            return n == 45;
        }
        try {
            switch (n) {
                case 44: {
                    return atomicComparer.comparesEqual(atomicValue, atomicValue2);
                }
                case 45: {
                    return !atomicComparer.comparesEqual(atomicValue, atomicValue2);
                }
                case 46: {
                    return atomicComparer.compareAtomicValues(atomicValue, atomicValue2) > 0;
                }
                case 47: {
                    return atomicComparer.compareAtomicValues(atomicValue, atomicValue2) < 0;
                }
                case 48: {
                    return atomicComparer.compareAtomicValues(atomicValue, atomicValue2) >= 0;
                }
                case 49: {
                    return atomicComparer.compareAtomicValues(atomicValue, atomicValue2) <= 0;
                }
            }
            throw new UnsupportedOperationException("Unknown operator " + n);
        }
        catch (ClassCastException classCastException) {
            DynamicError dynamicError = new DynamicError("Cannot compare " + Type.displayTypeName(atomicValue) + " to " + Type.displayTypeName(atomicValue2));
            dynamicError.setErrorCode("XPTY0004");
            dynamicError.setIsTypeError(true);
            throw dynamicError;
        }
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        try {
            AtomicValue atomicValue;
            AtomicValue atomicValue2 = (AtomicValue)this.operand0.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return this.resultWhenEmpty;
            }
            if (atomicValue2 instanceof UntypedAtomicValue) {
                atomicValue2 = atomicValue2.convert(BuiltInAtomicType.STRING, xPathContext);
            }
            if ((atomicValue = (AtomicValue)this.operand1.evaluateItem(xPathContext)) == null) {
                return this.resultWhenEmpty;
            }
            if (atomicValue instanceof UntypedAtomicValue) {
                atomicValue = atomicValue.convert(BuiltInAtomicType.STRING, xPathContext);
            }
            return BooleanValue.get(ValueComparison.compare(atomicValue2, this.operator, atomicValue, this.comparer));
        }
        catch (DynamicError dynamicError) {
            if (dynamicError.getXPathContext() == null) {
                dynamicError.setXPathContext(xPathContext);
            }
            if (dynamicError.getLocator() == null) {
                dynamicError.setLocator(this);
            }
            throw dynamicError;
        }
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return BuiltInAtomicType.BOOLEAN;
    }

    public int computeCardinality() {
        if (this.resultWhenEmpty != null) {
            return 16384;
        }
        return super.computeCardinality();
    }

    protected String displayOperator() {
        return Token.tokens[this.operator] + (this.resultWhenEmpty == null ? "" : " (on empty return " + this.resultWhenEmpty + ')');
    }
}

