/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.layout.renderer.aspect.impl;

import java.util.Iterator;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.layout.CompositeLayout;
import org.apache.cocoon.portal.layout.Item;
import org.apache.cocoon.portal.layout.Layout;
import org.apache.cocoon.portal.layout.renderer.Renderer;
import org.apache.cocoon.portal.layout.renderer.aspect.RendererAspectContext;
import org.apache.cocoon.portal.layout.renderer.aspect.impl.AbstractAspect;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractCompositeAspect
extends AbstractAspect {
    public void toSAX(RendererAspectContext context, Layout layout, PortalService service, ContentHandler handler) throws SAXException {
        if (layout instanceof CompositeLayout) {
            CompositeLayout compositeLayout = (CompositeLayout)layout;
            Iterator iter = compositeLayout.getItems().iterator();
            while (iter.hasNext()) {
                Item item = (Item)iter.next();
                this.processItem(item, handler, service);
            }
        } else {
            throw new SAXException("CompositeLayout expected.");
        }
    }

    protected abstract void processItem(Item var1, ContentHandler var2, PortalService var3) throws SAXException;

    protected void processLayout(Layout layout, PortalService service, ContentHandler handler) throws SAXException {
        String rendererName = layout.getRendererName();
        Renderer renderer = service.getComponentManager().getRenderer(rendererName);
        renderer.toSAX(layout, service, handler);
    }
}

