/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.auth.impl;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.auth.Application;
import org.apache.cocoon.auth.ApplicationManager;
import org.apache.cocoon.auth.ApplicationUtil;
import org.apache.cocoon.auth.User;
import org.apache.cocoon.auth.impl.LoginInfo;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.commons.lang.ObjectUtils;

public class StandardApplicationManager
extends AbstractLogEnabled
implements ApplicationManager,
Contextualizable,
Serviceable,
ThreadSafe,
Disposable {
    protected static final String LOGIN_INFO_KEY = StandardApplicationManager.class.getName() + "/logininfo";
    protected static final String APPLICATION_KEY_PREFIX = StandardApplicationManager.class.getName() + "/app:";
    protected Context context;
    protected ServiceManager manager;

    public void contextualize(Context aContext) throws ContextException {
        this.context = aContext;
        try {
            ServletConfig config = (ServletConfig)this.context.get((Object)"servlet-config");
            config.getServletContext().setAttribute(StandardApplicationManager.class.getName(), (Object)this);
        }
        catch (ContextException contextException) {
            // empty catch block
        }
    }

    public void service(ServiceManager aManager) throws ServiceException {
        this.manager = aManager;
    }

    public void dispose() {
        this.manager = null;
    }

    protected Application getApplication(String appName) throws Exception {
        ServiceManager current = (ServiceManager)this.context.get((Object)"sitemap-service-manager");
        Object o = current.lookup(Application.class.getName() + '/' + appName);
        if (o == null) {
            throw new ConfigurationException("Application '" + appName + "' not found.");
        }
        current.release(o);
        return (Application)o;
    }

    public boolean isLoggedIn(String appName) {
        Object appData = null;
        Map objectModel = ContextHelper.getObjectModel((Context)this.context);
        Request req = ObjectModelHelper.getRequest((Map)objectModel);
        Session session = req.getSession(false);
        if (session != null && (appData = session.getAttribute(APPLICATION_KEY_PREFIX + appName)) != null) {
            try {
                Application application = this.getApplication(appName);
                User user = (User)session.getAttribute("cauth-user-" + appName);
                Application oldApp = (Application)objectModel.get("cauth-application");
                objectModel.put("cauth-application", application);
                objectModel.put("cauth-application-data", appData);
                objectModel.put("cauth-user", user);
                if (oldApp == null || !oldApp.equals(application)) {
                    application.userIsAccessing(user);
                }
            }
            catch (Exception ignore) {
                throw new CascadingRuntimeException("Unable to get application '" + appName + "'", (Throwable)ignore);
            }
        }
        return appData != null;
    }

    public User login(String appName, Map loginContext) throws Exception {
        User user = null;
        Map objectModel = ContextHelper.getObjectModel((Context)this.context);
        if (this.isLoggedIn(appName)) {
            user = ApplicationUtil.getUser(objectModel);
        } else {
            Request req = ObjectModelHelper.getRequest((Map)objectModel);
            Session session = req.getSession(false);
            Application app = this.getApplication(appName);
            LoginInfo info = null;
            Map<String, LoginInfo> loginInfos = null;
            if (session != null && (loginInfos = (HashMap<String, LoginInfo>)session.getAttribute(LOGIN_INFO_KEY)) != null && loginInfos.containsKey(app.getSecurityHandler())) {
                info = (LoginInfo)loginInfos.get(app.getSecurityHandler());
                user = info.user;
            }
            if (user == null && (user = app.getSecurityHandler().login(loginContext)) != null) {
                session = req.getSession();
                loginInfos = (Map)session.getAttribute(LOGIN_INFO_KEY);
                if (loginInfos == null) {
                    loginInfos = new HashMap<String, LoginInfo>();
                }
                info = new LoginInfo(user);
                loginInfos.put(app.getSecurityHandler().getId(), info);
            }
            if (user != null) {
                info.incUsageCounter(appName);
                session.setAttribute(LOGIN_INFO_KEY, (Object)loginInfos);
                session.setAttribute("cauth-user-" + appName, (Object)user);
                objectModel.put("cauth-user", user);
                objectModel.put("cauth-application", app);
                app.userDidLogin(user, loginContext);
                Object data = ObjectUtils.NULL;
                if (app.getApplicationStore() != null) {
                    data = app.getApplicationStore().loadApplicationData(user, app);
                }
                session.setAttribute(APPLICATION_KEY_PREFIX + appName, data);
                objectModel.put("cauth-application-data", data);
                app.userIsAccessing(user);
            }
        }
        return user;
    }

    public void logout(String appName, Map logoutContext) {
        Map objectModel = ContextHelper.getObjectModel((Context)this.context);
        Request req = ObjectModelHelper.getRequest((Map)objectModel);
        Session session = req.getSession(false);
        if (session != null) {
            LoginInfo info;
            Application app;
            try {
                app = this.getApplication(appName);
            }
            catch (Exception ignore) {
                throw new CascadingRuntimeException("Unable to get application '" + appName + "'", (Throwable)ignore);
            }
            session.removeAttribute(APPLICATION_KEY_PREFIX + appName);
            if (app.equals(ApplicationUtil.getApplication(objectModel))) {
                objectModel.remove("cauth-application");
                objectModel.remove("cauth-application-data");
                objectModel.remove("cauth-user");
            }
            session.removeAttribute("cauth-user-" + appName);
            Map loginInfos = (Map)session.getAttribute(LOGIN_INFO_KEY);
            if (loginInfos != null && (info = (LoginInfo)loginInfos.get(app.getSecurityHandler().getId())) != null) {
                app.userWillLogout(info.user, logoutContext);
                info.decUsageCounter(appName);
                if (info.isUsed()) {
                    session.setAttribute(LOGIN_INFO_KEY, (Object)loginInfos);
                } else {
                    app.getSecurityHandler().logout(logoutContext, info.user);
                    loginInfos.remove(app.getSecurityHandler().getId());
                    if (loginInfos.size() > 0) {
                        session.setAttribute(LOGIN_INFO_KEY, (Object)loginInfos);
                    } else {
                        session.removeAttribute(LOGIN_INFO_KEY);
                        String mode = null;
                        if (logoutContext != null) {
                            mode = (String)logoutContext.get("mode");
                        }
                        if (mode == null || mode.equals("0")) {
                            session.invalidate();
                        }
                    }
                }
            }
        }
    }
}

