/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup.xsp;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.ResultSet;
import org.apache.avalon.framework.CascadingRuntimeException;

public class EsqlHelper {
    private static Boolean TRUE = Boolean.TRUE;

    public static final byte[] getBlob(ResultSet set, String column) throws RuntimeException {
        byte[] result = null;
        try {
            result = EsqlHelper.getBlob(set, set.findColumn(column));
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error getting blob data for column " + column, (Throwable)e);
        }
        return result;
    }

    public static final byte[] getBlob(ResultSet set, int column) throws Exception {
        InputStream reader = null;
        byte[] buffer = null;
        Object dbBlob = null;
        try {
            if (set.getMetaData().getColumnType(column) == 2004) {
                dbBlob = set.getBlob(column);
                int length = (int)dbBlob.length();
                reader = dbBlob.getBinaryStream();
                buffer = new byte[length];
                reader.read(buffer);
                reader.close();
                if (reader != null) {
                    reader.close();
                }
                if (buffer == null) {
                    byte[] byArray = null;
                    return byArray;
                }
                byte[] byArray = buffer;
                return byArray;
            }
            byte[] length = set.getString(column).getBytes();
            return length;
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error getting blob data for column " + column, (Throwable)e);
        }
        finally {
            if (dbBlob != null && dbBlob.getClass().getName().equals("oracle.sql.BLOB") && dbBlob.getClass().getMethod("isTemporary", new Class[0]).invoke(dbBlob, new Object[0]).equals(TRUE)) {
                dbBlob.getClass().getMethod("freeTemporary", new Class[0]).invoke(dbBlob, new Object[0]);
            }
        }
    }

    public static final byte[] getBlob(CallableStatement cs, int column, String defaultString) throws Exception {
        InputStream reader = null;
        byte[] buffer = null;
        Object result = null;
        Blob dbBlob = null;
        try {
            dbBlob = cs.getBlob(column);
            int length = (int)dbBlob.length();
            reader = dbBlob.getBinaryStream();
            buffer = new byte[length];
            reader.read(buffer);
            reader.close();
            if (reader != null) {
                reader.close();
            }
            result = buffer != null ? buffer : (Object)(defaultString != null && !defaultString.equals("_null_") ? defaultString.getBytes() : null);
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error getting blob data for column " + column, (Throwable)e);
        }
        finally {
            if (dbBlob != null && dbBlob.getClass().getName().equals("oracle.sql.BLOB") && dbBlob.getClass().getMethod("isTemporary", new Class[0]).invoke((Object)dbBlob, new Object[0]).equals(TRUE)) {
                dbBlob.getClass().getMethod("freeTemporary", new Class[0]).invoke((Object)dbBlob, new Object[0]);
            }
        }
        return result;
    }

    public static final String getStringOrClob(ResultSet set, String column, String defaultString) throws RuntimeException {
        String result = null;
        try {
            result = EsqlHelper.getStringOrClob(set, set.findColumn(column), defaultString);
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error getting text from column " + column, (Throwable)e);
        }
        return result;
    }

    public static final String getStringOrClob(ResultSet set, int column, String defaultString) throws Exception {
        BufferedReader reader = null;
        char[] buffer = null;
        String result = null;
        Object dbClob = null;
        try {
            if (set.getMetaData().getColumnType(column) == 2005) {
                dbClob = set.getClob(column);
                int length = (int)dbClob.length();
                reader = new BufferedReader(dbClob.getCharacterStream());
                buffer = new char[length];
                reader.read(buffer);
                ((Reader)reader).close();
                if (reader != null) {
                    ((Reader)reader).close();
                }
                result = buffer != null ? new String(buffer) : (defaultString != null && !defaultString.equals("_null_") ? defaultString : null);
            } else {
                result = set.getString(column);
                if (result == null && defaultString != null && !defaultString.equals("_null_")) {
                    result = defaultString;
                }
            }
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error getting text from column " + column, (Throwable)e);
        }
        finally {
            if (dbClob != null && dbClob.getClass().getName().equals("oracle.sql.CLOB")) {
                try {
                    if (dbClob.getClass().getMethod("isTemporary", new Class[0]).invoke(dbClob, new Object[0]).equals(TRUE)) {
                        dbClob.getClass().getMethod("freeTemporary", new Class[0]).invoke(dbClob, new Object[0]);
                    }
                }
                catch (Exception e1) {}
            }
        }
        return result;
    }

    public static final String getStringOrClob(CallableStatement cs, int column, String defaultString) throws Exception {
        BufferedReader reader = null;
        char[] buffer = null;
        String result = null;
        Clob dbClob = null;
        try {
            dbClob = cs.getClob(column);
            int length = (int)dbClob.length();
            reader = new BufferedReader(dbClob.getCharacterStream());
            buffer = new char[length];
            reader.read(buffer);
            ((Reader)reader).close();
            if (reader != null) {
                ((Reader)reader).close();
            }
            result = buffer != null ? new String(buffer) : (defaultString != null && !defaultString.equals("_null_") ? defaultString : null);
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error getting text from column " + column, (Throwable)e);
        }
        finally {
            if (dbClob != null && dbClob.getClass().getName().equals("oracle.sql.CLOB")) {
                try {
                    if (dbClob.getClass().getMethod("isTemporary", new Class[0]).invoke((Object)dbClob, new Object[0]).equals(TRUE)) {
                        dbClob.getClass().getMethod("freeTemporary", new Class[0]).invoke((Object)dbClob, new Object[0]);
                    }
                }
                catch (Exception e1) {}
            }
        }
        return result;
    }

    public static final String getAscii(ResultSet set, String column, String defaultString) throws RuntimeException {
        String result = null;
        try {
            result = EsqlHelper.getAscii(set, set.findColumn(column), defaultString);
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error getting ascii data for column " + column, (Throwable)e);
        }
        return result;
    }

    public static final String getAscii(ResultSet set, int column, String defaultString) {
        InputStream asciiStream = null;
        String result = null;
        Object dbClob = null;
        try {
            if (set.getMetaData().getColumnType(column) == 2005) {
                byte[] buffer = null;
                dbClob = set.getClob(column);
                int length = (int)dbClob.length();
                asciiStream = new BufferedInputStream(dbClob.getAsciiStream());
                buffer = new byte[length];
                asciiStream.read(buffer);
                asciiStream.close();
                result = buffer != null ? new String(buffer) : (defaultString != null && !defaultString.equals("_null_") ? defaultString : null);
            } else {
                result = set.getString(column);
                if (result == null && defaultString != null && !defaultString.equals("_null_")) {
                    result = defaultString;
                }
            }
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error getting ascii data from column " + column, (Throwable)e);
        }
        finally {
            if (asciiStream != null) {
                try {
                    asciiStream.close();
                }
                catch (Exception ase) {
                    throw new CascadingRuntimeException("Error closing clob stream", (Throwable)ase);
                }
            }
            if (dbClob != null && dbClob.getClass().getName().equals("oracle.sql.CLOB")) {
                try {
                    if (dbClob.getClass().getMethod("isTemporary", new Class[0]).invoke(dbClob, new Object[0]).equals(TRUE)) {
                        dbClob.getClass().getMethod("freeTemporary", new Class[0]).invoke(dbClob, new Object[0]);
                    }
                }
                catch (Exception e1) {}
            }
        }
        return result;
    }

    public static final String getAscii(CallableStatement cs, int column, String defaultString) {
        InputStream asciiStream = null;
        String result = null;
        Clob dbClob = null;
        try {
            byte[] buffer = null;
            dbClob = cs.getClob(column);
            int length = (int)dbClob.length();
            asciiStream = new BufferedInputStream(dbClob.getAsciiStream());
            buffer = new byte[length];
            asciiStream.read(buffer);
            asciiStream.close();
            result = buffer != null ? new String(buffer) : (defaultString != null && !defaultString.equals("_null_") ? defaultString : null);
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error getting ascii data for column " + column, (Throwable)e);
        }
        finally {
            if (asciiStream != null) {
                try {
                    asciiStream.close();
                }
                catch (Exception ase) {
                    throw new CascadingRuntimeException("Error closing clob stream", (Throwable)ase);
                }
            }
            if (dbClob != null && dbClob.getClass().getName().equals("oracle.sql.CLOB")) {
                try {
                    if (dbClob.getClass().getMethod("isTemporary", new Class[0]).invoke((Object)dbClob, new Object[0]).equals(TRUE)) {
                        dbClob.getClass().getMethod("freeTemporary", new Class[0]).invoke((Object)dbClob, new Object[0]);
                    }
                }
                catch (Exception e1) {}
            }
        }
        return result;
    }

    public static final String getStringFromByteArray(byte[] bytes, String encoding, String defaultString) {
        if (bytes != null) {
            try {
                return new String(bytes, encoding);
            }
            catch (UnsupportedEncodingException uee) {
                throw new CascadingRuntimeException("Unsupported Encoding Exception", (Throwable)uee);
            }
        }
        if (defaultString != null && !defaultString.equals("_null_")) {
            return defaultString;
        }
        return null;
    }
}

