/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fo.pagination.SubSequenceSpecifier;
import org.xml.sax.Locator;

public class PageSequenceMaster
extends FObj {
    private String masterName;
    private LayoutMasterSet layoutMasterSet;
    private List subSequenceSpecifiers;
    private SubSequenceSpecifier currentSubSequence;
    private int currentSubSequenceNumber = -1;

    public PageSequenceMaster(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.masterName = pList.get(140).getString();
        if (this.masterName == null || this.masterName.equals("")) {
            this.missingPropertyError("master-name");
        }
    }

    protected void startOfNode() throws FOPException {
        this.subSequenceSpecifiers = new ArrayList();
        this.layoutMasterSet = this.parent.getRoot().getLayoutMasterSet();
        this.layoutMasterSet.addPageSequenceMaster(this.masterName, this);
    }

    protected void endOfNode() throws FOPException {
        if (this.firstChild == null) {
            this.missingChildElementError("(single-page-master-reference|repeatable-page-master-reference|repeatable-page-master-alternatives)+");
        }
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(nsURI)) {
            if (!(localName.equals("single-page-master-reference") || localName.equals("repeatable-page-master-reference") || localName.equals("repeatable-page-master-alternatives"))) {
                this.invalidChildError(loc, nsURI, localName);
            }
        } else {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    protected void addSubsequenceSpecifier(SubSequenceSpecifier pageMasterReference) {
        this.subSequenceSpecifiers.add(pageMasterReference);
    }

    private SubSequenceSpecifier getNextSubSequence() {
        ++this.currentSubSequenceNumber;
        if (this.currentSubSequenceNumber >= 0 && this.currentSubSequenceNumber < this.subSequenceSpecifiers.size()) {
            return (SubSequenceSpecifier)this.subSequenceSpecifiers.get(this.currentSubSequenceNumber);
        }
        return null;
    }

    public void reset() {
        this.currentSubSequenceNumber = -1;
        this.currentSubSequence = null;
        if (this.subSequenceSpecifiers != null) {
            for (int i = 0; i < this.subSequenceSpecifiers.size(); ++i) {
                ((SubSequenceSpecifier)this.subSequenceSpecifiers.get(i)).reset();
            }
        }
    }

    public boolean goToPreviousSimplePageMaster() {
        boolean success;
        if (this.currentSubSequence != null && !(success = this.currentSubSequence.goToPrevious())) {
            if (this.currentSubSequenceNumber > 0) {
                --this.currentSubSequenceNumber;
                this.currentSubSequence = (SubSequenceSpecifier)this.subSequenceSpecifiers.get(this.currentSubSequenceNumber);
            } else {
                this.currentSubSequence = null;
            }
        }
        return this.currentSubSequence != null;
    }

    public boolean hasPagePositionLast() {
        if (this.currentSubSequence != null) {
            return this.currentSubSequence.hasPagePositionLast();
        }
        return false;
    }

    public SimplePageMaster getNextSimplePageMaster(boolean isOddPage, boolean isFirstPage, boolean isLastPage, boolean isBlankPage) throws FOPException {
        if (this.currentSubSequence == null) {
            this.currentSubSequence = this.getNextSubSequence();
            if (this.currentSubSequence == null) {
                throw new FOPException("no subsequences in page-sequence-master '" + this.masterName + "'");
            }
        }
        String pageMasterName = this.currentSubSequence.getNextPageMasterName(isOddPage, isFirstPage, isLastPage, isBlankPage);
        boolean canRecover = true;
        while (pageMasterName == null) {
            SubSequenceSpecifier nextSubSequence = this.getNextSubSequence();
            if (nextSubSequence == null) {
                if (!canRecover) {
                    throw new FOPException("subsequences exhausted in page-sequence-master '" + this.masterName + "', cannot recover");
                }
                log.warn((Object)("subsequences exhausted in page-sequence-master '" + this.masterName + "', using previous subsequence"));
                this.currentSubSequence.reset();
                canRecover = false;
            } else {
                this.currentSubSequence = nextSubSequence;
            }
            pageMasterName = this.currentSubSequence.getNextPageMasterName(isOddPage, isFirstPage, isLastPage, isBlankPage);
        }
        SimplePageMaster pageMaster = this.layoutMasterSet.getSimplePageMaster(pageMasterName);
        if (pageMaster == null) {
            throw new FOPException("No simple-page-master matching '" + pageMasterName + "' in page-sequence-master '" + this.masterName + "'");
        }
        return pageMaster;
    }

    public String getLocalName() {
        return "page-sequence-master";
    }

    public int getNameId() {
        return 33;
    }
}

