/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.util.Settings;
import org.apache.cocoon.util.SettingsHelper;

public class PropertyAwareConfiguration
extends DefaultConfiguration {
    private Settings settings;
    private Logger logger;

    public PropertyAwareConfiguration(Configuration config, boolean deepCopy, Settings settings, Logger logger) throws ConfigurationException {
        super(config, deepCopy);
        this.settings = settings;
        this.logger = logger;
    }

    public PropertyAwareConfiguration(Configuration config, Settings settings, Logger logger) throws ConfigurationException {
        super(config);
        this.settings = settings;
        this.logger = logger;
    }

    public PropertyAwareConfiguration(String name, Settings settings, Logger logger) {
        super(name);
        this.settings = settings;
        this.logger = logger;
    }

    public PropertyAwareConfiguration(String name, String location, Settings settings, Logger logger) {
        super(name, location);
        this.settings = settings;
        this.logger = logger;
    }

    public PropertyAwareConfiguration(String name, String location, String ns, String prefix, Settings settings, Logger logger) {
        super(name, location, ns, prefix);
        this.settings = settings;
        this.logger = logger;
    }

    public PropertyAwareConfiguration(DefaultConfiguration config, Settings settings, Logger logger) throws ConfigurationException {
        super((Configuration)config, false);
        this.settings = settings;
        this.logger = logger;
    }

    public void setValue(String value) {
        super.setValue(SettingsHelper.replace(value, this.settings, this.logger));
    }

    public void setAttribute(String name, String value) {
        super.setAttribute(name, SettingsHelper.replace(value, this.settings, this.logger));
    }
}

