/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.components.flow.FlowHelper;
import org.apache.cocoon.components.flow.javascript.JavaScriptFlowHelper;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.commons.io.IOUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PipelineUtil
implements Contextualizable,
Serviceable,
Disposable {
    private Context context;
    private ServiceManager manager;
    private SourceResolver resolver;

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.resolver);
            this.manager = null;
            this.resolver = null;
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    private void checkSetup() {
        if (this.manager == null) {
            throw new IllegalStateException("Instances of " + this.getClass().getName() + " must be setup using either cocoon.createObject() or cocoon.setupObject().");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processToStream(String uri, Object viewData, OutputStream output) throws IOException {
        Source src;
        Object oldViewData;
        Map objectModel;
        block8: {
            this.checkSetup();
            objectModel = ContextHelper.getObjectModel(this.context);
            oldViewData = FlowHelper.getContextObject(objectModel);
            FlowHelper.setContextObject(objectModel, JavaScriptFlowHelper.unwrap(viewData));
            src = null;
            InputStream input = null;
            try {
                src = this.resolver.resolveURI("cocoon:/" + uri);
                input = src.getInputStream();
                IOUtils.copy((InputStream)input, (OutputStream)output);
                Object var9_8 = null;
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
                FlowHelper.setContextObject(objectModel, oldViewData);
                if (src != null) {
                    this.resolver.release(src);
                }
                throw throwable;
            }
            try {
                input.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        FlowHelper.setContextObject(objectModel, oldViewData);
        if (src != null) {
            this.resolver.release(src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processToSAX(String uri, Object viewData, ContentHandler handler) throws SAXException, IOException, ProcessingException {
        this.checkSetup();
        Map objectModel = ContextHelper.getObjectModel(this.context);
        Object oldViewData = FlowHelper.getContextObject(objectModel);
        FlowHelper.setContextObject(objectModel, JavaScriptFlowHelper.unwrap(viewData));
        Source src = null;
        try {
            src = this.resolver.resolveURI("cocoon:/" + uri);
            SourceUtil.toSAX(src, handler);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            FlowHelper.setContextObject(objectModel, oldViewData);
            if (src != null) {
                this.resolver.release(src);
            }
            throw throwable;
        }
        FlowHelper.setContextObject(objectModel, oldViewData);
        if (src != null) {
            this.resolver.release(src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document processToDOM(String uri, Object viewData) throws ProcessingException, SAXException, IOException {
        Document document;
        this.checkSetup();
        Map objectModel = ContextHelper.getObjectModel(this.context);
        Object oldViewData = FlowHelper.getContextObject(objectModel);
        FlowHelper.setContextObject(objectModel, JavaScriptFlowHelper.unwrap(viewData));
        Source src = null;
        try {
            src = this.resolver.resolveURI("cocoon:/" + uri);
            document = SourceUtil.toDOM(src);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            block3: {
                Object var8_8 = null;
                FlowHelper.setContextObject(objectModel, oldViewData);
                if (src == null) break block3;
                this.resolver.release(src);
            }
            throw throwable;
        }
        FlowHelper.setContextObject(objectModel, oldViewData);
        if (src != null) {
            this.resolver.release(src);
        }
        return document;
    }
}

