/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.document;

import fr.gouv.culture.sdx.exception.SDXException;
import org.apache.excalibur.xml.sax.SAXParser;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLProducer;

/**
 * An interface for documents that can be parsed in an XML sense.
 *
 * <p>
 * Parsable documents include, of course, XML documents but also HTML
 * documents using JTidy.
 */
public interface ParsableDocument extends Document, XMLProducer {

    /** Parses a document using the previously supplied consumer.
     * @param   parser  The parser to use
     */
    public void parse(SAXParser parser) throws SDXException;

    /** Parses a document using a specific consumer.
     *
     *@param parser     The parser to use
     *@param consumer   The consumer of the events generated by the parse
     */
    public void parse(SAXParser parser, XMLConsumer consumer) throws SDXException;

}
