/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.types;

import org.apache.commons.lang.BooleanUtils;

public class Attribute {
    private String _name;
    private String _value;

    public Attribute(String name, String value) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Attribute name is null or empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("Attribute value is null");
        }
        this._name = name;
        this._value = value;
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public int getValueAsInt() {
        return Integer.parseInt(this._value);
    }

    public short getValueAsShort() {
        return Short.parseShort(this._value);
    }

    public long getValueAsLong() {
        return Long.parseLong(this._value);
    }

    public boolean getValueAsBoolean() {
        Boolean rvalue = BooleanUtils.toBooleanObject((String)this._value);
        if (rvalue != null) {
            return rvalue;
        }
        try {
            rvalue = BooleanUtils.toBooleanObject((String)this._value, (String)"t", (String)"f", null);
        }
        catch (IllegalArgumentException iae) {
            rvalue = null;
        }
        if (rvalue != null) {
            return rvalue;
        }
        try {
            rvalue = BooleanUtils.toBooleanObject((String)this._value, (String)"y", (String)"n", null);
        }
        catch (IllegalArgumentException iae) {
            rvalue = null;
        }
        if (rvalue != null) {
            return rvalue;
        }
        throw new IllegalArgumentException("Value [" + this._value + "] does not represent a boolean value");
    }
}

