/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;

public class MultiResGraphicsNode
extends AbstractGraphicsNode
implements SVGConstants {
    SoftReference[] srcs;
    Element[] srcElems;
    Dimension[] minSz;
    Dimension[] maxSz;
    Rectangle2D bounds;
    BridgeContext ctx;
    Element multiImgElem;

    public MultiResGraphicsNode(Element element, Rectangle2D rectangle2D, Element[] elementArray, Dimension[] dimensionArray, Dimension[] dimensionArray2, BridgeContext bridgeContext) {
        this.multiImgElem = element;
        this.srcElems = new Element[elementArray.length];
        this.minSz = new Dimension[elementArray.length];
        this.maxSz = new Dimension[elementArray.length];
        this.ctx = bridgeContext;
        for (int i = 0; i < elementArray.length; ++i) {
            this.srcElems[i] = elementArray[i];
            this.minSz[i] = dimensionArray[i];
            this.maxSz[i] = dimensionArray2[i];
        }
        this.srcs = new SoftReference[elementArray.length];
        this.bounds = rectangle2D;
    }

    public void primitivePaint(Graphics2D graphics2D) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        AffineTransform affineTransform = graphics2D.getTransform();
        double d6 = Math.sqrt(affineTransform.getShearY() * affineTransform.getShearY() + affineTransform.getScaleX() * affineTransform.getScaleX());
        double d7 = Math.sqrt(affineTransform.getShearX() * affineTransform.getShearX() + affineTransform.getScaleY() * affineTransform.getScaleY());
        GraphicsNode graphicsNode = null;
        int n = -1;
        double d8 = this.bounds.getWidth() * d6;
        double d9 = this.calcDist(d8, this.minSz[0], this.maxSz[0]);
        int n2 = 0;
        for (int i = 0; i < this.minSz.length; ++i) {
            d5 = this.calcDist(d8, this.minSz[i], this.maxSz[i]);
            if (d5 < d9) {
                d9 = d5;
                n2 = i;
            }
            if (this.minSz[i] != null && !(d8 >= (double)this.minSz[i].width) || this.maxSz[i] != null && !(d8 <= (double)this.maxSz[i].width) || n != -1 && n2 != i) continue;
            n = i;
        }
        if (n == -1) {
            n = n2;
        }
        if ((graphicsNode = this.getGraphicsNode(n)) == null) {
            return;
        }
        Rectangle2D rectangle2D = graphicsNode.getBounds();
        d5 = rectangle2D.getWidth() * d6;
        double d10 = rectangle2D.getHeight() * d7;
        double d11 = rectangle2D.getX() * d6;
        double d12 = rectangle2D.getY() * d7;
        if (d5 < 0.0) {
            d4 = d11 + d5;
            d3 = d11;
        } else {
            d4 = d11;
            d3 = d11 + d5;
        }
        if (d10 < 0.0) {
            d2 = d12 + d10;
            d = d12;
        } else {
            d2 = d12;
            d = d12 + d10;
        }
        d5 = (int)(Math.ceil(d3) - Math.floor(d4));
        d10 = (int)(Math.ceil(d) - Math.floor(d2));
        d6 = d5 / rectangle2D.getWidth() / d6;
        d7 = d10 / rectangle2D.getHeight() / d7;
        AffineTransform affineTransform2 = graphics2D.getTransform();
        affineTransform2 = new AffineTransform(affineTransform2.getScaleX() * d6, affineTransform2.getShearY() * d6, affineTransform2.getShearX() * d7, affineTransform2.getScaleY() * d7, affineTransform2.getTranslateX(), affineTransform2.getTranslateY());
        graphics2D.setTransform(affineTransform2);
        graphicsNode.paint(graphics2D);
    }

    public double calcDist(double d, Dimension dimension, Dimension dimension2) {
        if (dimension == null) {
            if (dimension2 == null) {
                return 1.0E11;
            }
            return Math.abs(d - (double)dimension2.width);
        }
        if (dimension2 == null) {
            return Math.abs(d - (double)dimension.width);
        }
        double d2 = (double)(dimension2.width + dimension.width) / 2.0;
        return Math.abs(d - d2);
    }

    public Rectangle2D getPrimitiveBounds() {
        return this.bounds;
    }

    public Rectangle2D getGeometryBounds() {
        return this.bounds;
    }

    public Rectangle2D getSensitiveBounds() {
        return this.bounds;
    }

    public Shape getOutline() {
        return this.bounds;
    }

    public GraphicsNode getGraphicsNode(int n) {
        GVTBuilder gVTBuilder;
        if (this.srcs[n] != null && (gVTBuilder = this.srcs[n].get()) != null) {
            return (GraphicsNode)((Object)gVTBuilder);
        }
        try {
            gVTBuilder = this.ctx.getGVTBuilder();
            GraphicsNode graphicsNode = gVTBuilder.build(this.ctx, this.srcElems[n]);
            this.srcs[n] = new SoftReference<GraphicsNode>(graphicsNode);
            return graphicsNode;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

