/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.jsp.JSPEngine;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JSPGenerator
extends ServiceableGenerator {
    public void generate() throws ProcessingException {
        HttpServletResponse servletResponse = (HttpServletResponse)this.objectModel.get("httpresponse");
        HttpServletRequest servletRequest = (HttpServletRequest)this.objectModel.get("httprequest");
        ServletContext servletContext = (ServletContext)this.objectModel.get("httpservletcontext");
        if (servletResponse == null || servletRequest == null || servletContext == null) {
            throw new ProcessingException("JSPGenerator can only be used from within a Servlet environment.");
        }
        JSPEngine engine = null;
        SAXParser parser = null;
        Source inputSource = null;
        Source contextSource = null;
        try {
            try {
                inputSource = this.resolver.resolveURI(this.source);
                contextSource = this.resolver.resolveURI("context:/");
                String inputSourceURI = inputSource.getURI();
                String contextSourceURI = contextSource.getURI();
                if (!inputSourceURI.startsWith(contextSourceURI)) {
                    throw new ProcessingException("You must not reference a file outside of the servlet context at " + contextSourceURI + ".");
                }
                String url = inputSourceURI.substring(contextSourceURI.length());
                if (url.charAt(0) != '/') {
                    url = "/" + url;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("JSPGenerator executing:" + url);
                }
                engine = (JSPEngine)this.manager.lookup(JSPEngine.ROLE);
                byte[] bytes = engine.executeJSP(url, servletRequest, servletResponse, servletContext);
                InputSource input = new InputSource(new ByteArrayInputStream(bytes));
                input.setEncoding("utf-8");
                parser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
                parser.parse(input, (ContentHandler)this.xmlConsumer);
            }
            catch (ServletException e) {
                throw new ProcessingException("ServletException while executing JSPEngine", (Throwable)e);
            }
            catch (SAXException e) {
                throw new ProcessingException("SAXException while parsing JSPEngine output", (Throwable)e);
            }
            catch (IOException e) {
                throw new ProcessingException("IOException JSPGenerator.generate()", (Throwable)e);
            }
            catch (ProcessingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ProcessingException("Exception JSPGenerator.generate()", (Throwable)e);
            }
            Object var14_18 = null;
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            this.manager.release(parser);
            this.manager.release(engine);
            this.resolver.release(inputSource);
            this.resolver.release(contextSource);
            throw throwable;
        }
        this.manager.release((Object)parser);
        this.manager.release((Object)engine);
        this.resolver.release(inputSource);
        this.resolver.release(contextSource);
    }
}

