/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.portlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.portlet.PortletCookie;

public abstract class PortletResponse
implements Response {
    private final javax.portlet.PortletResponse response;
    private final PortletPreferences preferences;
    private Map properties = new HashMap(5);

    protected PortletResponse(javax.portlet.PortletResponse response, PortletPreferences preferences) {
        this.response = response;
        this.preferences = preferences;
    }

    public boolean containsHeader(String name) {
        return this.properties.containsKey(name);
    }

    public void setHeader(String name, String value) {
        this.properties.put(name, name);
        this.response.setProperty(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, "" + value);
    }

    public void setDateHeader(String name, long date) {
        this.setHeader(name, "" + date);
    }

    public void addHeader(String name, String value) {
        this.properties.put(name, name);
        this.response.addProperty(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, "" + value);
    }

    public void addDateHeader(String name, long date) {
        this.addHeader(name, "" + date);
    }

    public String getCharacterEncoding() {
        return null;
    }

    public Cookie createCookie(String name, String value) {
        return new PortletCookie(name, value);
    }

    public void addCookie(Cookie cookie) {
        try {
            this.preferences.setValue(cookie.getName(), cookie.getValue());
            this.preferences.store();
        }
        catch (ReadOnlyException e) {
            throw new CascadingRuntimeException("Cannot set read-only preference '" + cookie.getName() + "'", (Throwable)e);
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Cannot set preference '" + cookie.getName() + "'", (Throwable)e);
        }
    }

    public void setLocale(Locale locale) {
    }

    public Locale getLocale() {
        return null;
    }

    public String encodeURL(String url) {
        if (url != null && url.indexOf(";jsessionid=") != -1) {
            return url;
        }
        return this.response.encodeURL(url);
    }

    public javax.portlet.PortletResponse getPortletResponse() {
        return this.response;
    }

    public void addProperty(String key, String value) {
        this.getPortletResponse().addProperty(key, value);
    }

    public void setProperty(String key, String value) {
        this.getPortletResponse().setProperty(key, value);
    }

    OutputStream getOutputStream() throws IOException {
        throw new IllegalStateException("Operation 'getOutputStream' is not supported by '" + this.getClass().getName() + "'");
    }

    void setContentType(String type) {
        throw new IllegalStateException("Operation 'setContentType' is not supported by '" + this.getClass().getName() + "'");
    }

    void sendRedirect(String location) throws IOException {
        throw new IllegalStateException("Operation 'sendRedirect' is not supported by '" + this.getClass().getName() + "'");
    }

    boolean isCommitted() {
        throw new IllegalStateException("Operation 'isCommitted' is not supported by '" + this.getClass().getName() + "'");
    }

    void reset() {
        throw new IllegalStateException("Operation 'reset' is not supported by '" + this.getClass().getName() + "'");
    }
}

