/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.Platform;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;

public class ResolveURI
extends SystemFunction {
    String expressionBaseURI = null;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(staticContext);
            this.expressionBaseURI = staticContext.getBaseURI();
            if (this.expressionBaseURI == null && this.argument.length == 1) {
                DynamicError dynamicError = new DynamicError("Base URI in static context of resolve-uri() is unknown");
                dynamicError.setErrorCode("FONS0005");
                throw dynamicError;
            }
        }
    }

    public String getStaticBaseURI() {
        return this.expressionBaseURI;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        String string;
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return null;
        }
        String string2 = atomicValue.getStringValue();
        if (this.argument.length == 2) {
            string = this.argument[1].evaluateAsString(xPathContext);
        } else {
            string = this.expressionBaseURI;
            if (this.expressionBaseURI == null) {
                this.dynamicError("Base URI in static context of resolve-uri() is unknown", "FONS0005", xPathContext);
                return null;
            }
        }
        Platform platform = Configuration.getPlatform();
        try {
            URI uRI = platform.makeAbsolute(string2, string);
            return new AnyURIValue(uRI.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            this.dynamicError("Base URI " + Err.wrap(string) + " is invalid: " + uRISyntaxException.getMessage(), "FORG0002", xPathContext);
            return null;
        }
    }

    public static String tryToExpand(String string) {
        if (string == null) {
            string = "";
        }
        try {
            new URL(string);
            return string;
        }
        catch (MalformedURLException malformedURLException) {
            String string2;
            try {
                string2 = System.getProperty("user.dir");
            }
            catch (Exception exception) {
                return string;
            }
            if (!string2.endsWith("/") && !string.startsWith("/")) {
                string2 = string2 + '/';
            }
            try {
                URL uRL = new File(string2).toURL();
                URL uRL2 = new URL(uRL, string);
                return uRL2.toString();
            }
            catch (MalformedURLException malformedURLException2) {
                return string;
            }
        }
    }

    public static String escapeSpaces(String string) {
        if (string == null) {
            return string;
        }
        int n = string.indexOf(32);
        if (n < 0) {
            return string;
        }
        return (n == 0 ? "" : string.substring(0, n)) + "%20" + (n == string.length() - 1 ? "" : ResolveURI.escapeSpaces(string.substring(n + 1)));
    }
}

