/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.serialization;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.cocoon.portal.serialization.ReplacingOutputStream;
import org.apache.cocoon.serialization.HTMLSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IncludingHTMLSerializer
extends HTMLSerializer {
    public static final ThreadLocal portlets = new ThreadLocal();
    public static final String NAMESPACE = "http://apache.org/cocoon/portal/include";
    protected LinkedList orderedPortletList = new LinkedList();
    protected static final char token = '~';
    protected static final char[] tokens = new char[]{'~', '~'};

    public void recycle() {
        super.recycle();
        Map map = (Map)portlets.get();
        if (map != null) {
            map.clear();
        }
        this.orderedPortletList.clear();
    }

    public static void addPortlet(String name, String content) {
        HashMap<String, String> map = (HashMap<String, String>)portlets.get();
        if (map == null) {
            map = new HashMap<String, String>();
            portlets.set(map);
        }
        map.put(name, content);
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        if (!NAMESPACE.equals(uri)) {
            super.endElement(uri, loc, raw);
        }
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        if (!NAMESPACE.equals(uri)) {
            super.startElement(uri, loc, raw, a);
        } else {
            String portletId = a.getValue("portlet");
            String value = null;
            Map map = (Map)portlets.get();
            if (map != null) {
                value = (String)map.get(portletId);
            }
            if (value != null) {
                this.orderedPortletList.addFirst(value);
                this.characters(tokens, 0, tokens.length);
            }
        }
    }

    public void setOutputStream(OutputStream stream) throws IOException {
        super.setOutputStream((OutputStream)new ReplacingOutputStream(stream, this.orderedPortletList));
    }
}

