/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Stack;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.style.UseWhenStaticContext;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;

public class UseWhenFilter
extends ProxyReceiver {
    private StartTagBuffer startTag;
    private int useWhenCode;
    private int xslUseWhenCode;
    private int defaultNamespaceCode;
    private int depthOfHole = 0;
    private boolean emptyStylesheetElement = false;
    private Stack defaultNamespaceStack = new Stack();

    public UseWhenFilter(StartTagBuffer startTagBuffer) {
        this.startTag = startTagBuffer;
    }

    public void open() throws XPathException {
        this.useWhenCode = this.getNamePool().allocate("", "", "use-when") & 0xFFFFF;
        this.xslUseWhenCode = this.getNamePool().allocate("xsl", "http://www.w3.org/1999/XSL/Transform", "use-when");
        this.defaultNamespaceCode = this.getNamePool().allocate("", "", "xpath-default-namespace");
        this.nextReceiver.open();
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        this.defaultNamespaceStack.push(this.startTag.getAttribute(this.defaultNamespaceCode));
        if (this.emptyStylesheetElement) {
            ++this.depthOfHole;
            return;
        }
        if (this.depthOfHole == 0) {
            block9: {
                short s = this.getNamePool().getURICode(n);
                String string = s == 2 ? this.startTag.getAttribute(this.useWhenCode) : this.startTag.getAttribute(this.xslUseWhenCode);
                if (string != null) {
                    try {
                        boolean bl = this.evaluateUseWhen(string, this.getDocumentLocator().getLineNumber(n3));
                        if (bl) break block9;
                        int n5 = n & 0xFFFFF;
                        if (n5 == 180 || n5 == 183) {
                            this.emptyStylesheetElement = true;
                            break block9;
                        }
                        this.depthOfHole = 1;
                        return;
                    }
                    catch (XPathException xPathException) {
                        StaticError staticError = new StaticError("Error in use-when expression. " + xPathException.getMessage());
                        ExpressionLocation expressionLocation = new ExpressionLocation();
                        expressionLocation.setSystemId(this.getDocumentLocator().getSystemId(n3));
                        expressionLocation.setLineNumber(this.getDocumentLocator().getLineNumber(n3));
                        staticError.setLocator(expressionLocation);
                        staticError.setErrorCode(xPathException.getErrorCodeLocalPart());
                        try {
                            this.getPipelineConfiguration().getErrorListener().fatalError(staticError);
                        }
                        catch (TransformerException transformerException) {
                            throw StaticError.makeStaticError(transformerException);
                        }
                        staticError.setHasBeenReported();
                        throw staticError;
                    }
                }
            }
            this.nextReceiver.startElement(n, n2, n3, n4);
        } else {
            ++this.depthOfHole;
        }
    }

    public void namespace(int n, int n2) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.namespace(n, n2);
        }
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.attribute(n, n2, charSequence, n3, n4);
        }
    }

    public void startContent() throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.startContent();
        }
    }

    public void endElement() throws XPathException {
        this.defaultNamespaceStack.pop();
        if (this.depthOfHole > 0) {
            --this.depthOfHole;
        } else {
            this.nextReceiver.endElement();
        }
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.characters(charSequence, n, n2);
        }
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) {
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
    }

    public boolean evaluateUseWhen(String string, int n) throws XPathException {
        Object object;
        UseWhenStaticContext useWhenStaticContext = new UseWhenStaticContext(this.getConfiguration(), this.startTag);
        useWhenStaticContext.setBaseURI(this.getDocumentLocator().getSystemId(n));
        useWhenStaticContext.setDefaultElementNamespace("");
        for (int i = this.defaultNamespaceStack.size() - 1; i >= 0; --i) {
            object = (String)this.defaultNamespaceStack.get(i);
            if (object == null) continue;
            useWhenStaticContext.setDefaultElementNamespace((String)object);
            break;
        }
        Expression expression = ExpressionTool.make(string, useWhenStaticContext, 0, 0, this.getDocumentLocator().getLineNumber(n), false);
        object = Type.ITEM_TYPE;
        expression = expression.typeCheck(useWhenStaticContext, (ItemType)object);
        SlotManager slotManager = this.getPipelineConfiguration().getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots(expression, slotManager.getNumberOfVariables(), slotManager);
        Controller controller = new Controller(this.getConfiguration());
        controller.setURIResolver(new URIPreventer());
        XPathContextMajor xPathContextMajor = controller.newXPathContext();
        xPathContextMajor = xPathContextMajor.newCleanContext();
        xPathContextMajor.openStackFrame(slotManager);
        return expression.effectiveBooleanValue(xPathContextMajor);
    }

    private static class URIPreventer
    implements URIResolver {
        private URIPreventer() {
        }

        public Source resolve(String string, String string2) throws TransformerException {
            throw new TransformerException("No external documents are available within an [xsl]use-when expression");
        }
    }
}

