/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.document;

import fr.gouv.culture.sdx.exception.SDXException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.excalibur.source.impl.AbstractSource;
import org.apache.cocoon.components.source.SourceUtil;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import java.io.IOException;

public class ParsableDocumentSource extends AbstractSource {

	protected ParsableDocument _parsableDocument = null;

	public ParsableDocumentSource(ServiceManager manager, ParsableDocument document) {
		_parsableDocument = document;
	}

/*
	public InputStream getInputStream()
			throws ProcessingException, IOException {
		return null;
	}
*/
	public InputSource getInputSource() throws IOException, ProcessingException {
		try {
			return ((AbstractDocument) _parsableDocument).getInputSource();
		} catch (SDXException e) {
			throw new ProcessingException(e);
		}
	}

	public String getSystemId() {
		try {
			return _parsableDocument.getURL().toExternalForm();
		} catch (SDXException e) {
			return null;
		}
	}

	/**
	 * Stream content to a content handler or to an XMLConsumer.
	 *
	 * @throws org.apache.cocoon.ResourceNotFoundException if file not found or
	 *         HTTP location does not exist.
	 * @throws org.xml.sax.SAXException if failed to parse source document.
	 */
	public void toSAX(ContentHandler handler) throws SAXException, ProcessingException {
		try {
			SourceUtil.toSAX(this,handler);
		} catch (IOException e) {
			throw new SAXException(e.getMessage(),e);
		}
//		SAXParser parser = null;
//		ServiceManager l_manager = super.manager;
//
//		try {
//			parser = (SAXParser) l_manager.lookup(SAXParser.ROLE);
//			_parsableDocument.parse(parser, new ContentHandlerWrapper(handler));
//		} catch (Exception e) {
//			throw new ProcessingException("Exception during processing of "
//					+ this.getSystemId(), e);
//		} finally {
//			if (parser != null) l_manager.release(parser);
//		}
	}

	/**
	 * @see org.apache.excalibur.source.Source#exists()
	 */
	public boolean exists() {
		// TODO Auto-generated method stub
		return false;
	}

}
