#include "common.h"
#include "words.h"

char** readWords(char* loc, int* numWords) {
    FILE* wordFile = fopen(loc, "r");
    
    if(wordFile == NULL) {
	fprintf(stderr, "Could not find file: %s\n", loc);
	exit(2);
    }
   
    int result = fscanf(wordFile, "%d\n", numWords);

    if(result < 1) {
	fprintf(stderr, "First line of words file must contain number of words.\n");
	exit(4);
    }

    char** words = malloc(sizeof(char*) * (*numWords));
    if(words == NULL) {
	fprintf(stderr, "Out of memory while allocating words.");
    }

    int i;
    for(i = 0; i < *numWords; i++) {
	words[i] = malloc(sizeof(char) * MAX_WORD_LEN);
	int result = fscanf(wordFile, "%s\n", words[i]);

	if(result < 1) {
	    fprintf(stderr, "Malformed words file. Could not read word.");
	    exit(4);
	}
    }

    return words;
}
