/*
 * Decompiled with CFR 0.152.
 */
package com.sandklef.jearduino;

import com.sandklef.jearduino.ArduinoCodeNameEvent;
import com.sandklef.jearduino.BoardEvent;
import com.sandklef.jearduino.DirEvent;
import com.sandklef.jearduino.FileEvent;
import com.sandklef.jearduino.InoDirEvent;
import com.sandklef.jearduino.JearduinoAbout;
import com.sandklef.jearduino.JearduinoEvent;
import com.sandklef.jearduino.TailerEvent;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class JearduinoMenu
extends JMenuBar
implements ActionListener {
    BoardEvent be;
    FileEvent fe;
    DirEvent de;
    InoDirEvent ie;
    JearduinoEvent je;
    ArduinoCodeNameEvent ae;
    TailerEvent te;
    JMenu arduinoMenu;
    JMenu boardMenu;
    JMenu helpMenu;
    JMenu searduinoMenu;
    JMenu codeMenu;
    JMenu prevCodeMenu;
    JRadioButtonMenuItem leoItem;
    JRadioButtonMenuItem unoItem;
    JRadioButtonMenuItem megaItem;
    JRadioButtonMenuItem mega2560Item;
    JMenuItem loadFromFile;
    JMenuItem importArduinoFileItem;
    JMenuItem verifyArduinoCodeItem;
    JMenuItem uploadArduinoCodeItem;
    JMenuItem openSearduinoProjectItem;
    JMenuItem buildItem;
    JMenuItem boardItem;
    JMenuItem aboutItem;
    JMenuItem manualItem;
    JMenuItem jearduinoManualItem;
    JMenuItem[] codeItem;
    JFileChooser fc;

    public JearduinoMenu(JearduinoEvent jearduinoEvent, BoardEvent boardEvent, FileEvent fileEvent, DirEvent dirEvent, InoDirEvent inoDirEvent, ArduinoCodeNameEvent arduinoCodeNameEvent) {
        this.be = boardEvent;
        this.fe = fileEvent;
        this.de = dirEvent;
        this.ae = arduinoCodeNameEvent;
        this.ie = inoDirEvent;
        this.je = jearduinoEvent;
        this.codeItem = new JMenuItem[10];
        this.arduinoMenu = new JMenu("Arduino");
        this.searduinoMenu = new JMenu("Searduino");
        this.boardMenu = new JMenu("Board");
        this.helpMenu = new JMenu("Help");
        this.loadFromFile = new JMenuItem("Load code from file");
        this.loadFromFile.addActionListener(this);
        this.codeMenu = new JMenu("Previous programs");
        this.add(this.searduinoMenu);
        this.add(this.arduinoMenu);
        this.add(this.boardMenu);
        this.add(this.helpMenu);
        this.createBoardMenu();
        this.createSearduinoMenu();
        this.createArduinoMenu();
        this.createHelpMenu();
    }

    public void findArduinoCode() {
        String string = System.getProperty("user.home") + "/searduino";
        String string2 = System.getProperty("searduino.project.dir");
        if (string2 == null) {
            string2 = string;
        }
        this.fc = new JFileChooser(new File(string2));
        int n = this.fc.showOpenDialog(this);
        if (n == 0) {
            File file = this.fc.getSelectedFile();
            try {
                System.out.println("Opening: " + file.getCanonicalPath());
                this.fe.handleArduinoFileEvent(file);
            }
            catch (IOException iOException) {
                System.out.println("Uh oh... could not get file name");
            }
        } else {
            System.out.println("Open command cancelled by user.");
        }
    }

    public void findInoCode() {
        String string = "/usr/share/doc/arduino-core/examples/";
        String string2 = System.getProperty("searduino.arduinoex.dir");
        if (string2 == null) {
            string2 = string;
        }
        this.fc = new JFileChooser(new File(string2));
        this.fc.setFileSelectionMode(1);
        int n = this.fc.showOpenDialog(this);
        if (n == 0) {
            File file = this.fc.getSelectedFile();
            try {
                System.out.println("Opening: " + file.getCanonicalPath());
                this.ie.handleInoDirEvent(file);
            }
            catch (IOException iOException) {
                System.out.println("Uh oh... could not get file name");
            }
        } else {
            System.out.println("Open command cancelled by user.");
        }
    }

    public void findSerduinoProject() {
        String string = System.getProperty("user.home") + "/searduino";
        String string2 = System.getProperty("searduino.project.dir");
        if (string2 == null) {
            string2 = string;
        }
        this.fc = new JFileChooser(new File(string2));
        this.fc.setFileSelectionMode(1);
        int n = this.fc.showOpenDialog(this);
        if (n == 0) {
            File file = this.fc.getSelectedFile();
            try {
                System.out.println("Opening: " + file.getCanonicalPath());
                this.de.handleSearduinoDirEvent(file);
            }
            catch (IOException iOException) {
                System.out.println("Uh oh... could not get file name");
            }
        } else {
            System.out.println("Open command cancelled by user.");
        }
    }

    public void showAbout() {
        JearduinoAbout jearduinoAbout = new JearduinoAbout();
        jearduinoAbout.pack();
        jearduinoAbout.setVisible(true);
    }

    public void showManual() {
        String string = System.getenv("SEARDUINO_PATH");
        if (string == null) {
            System.out.println("Could not open manual.");
            System.out.println("   Searduino path not set.");
            return;
        }
        String string2 = string + "/share/searduino/doc/searduino-manual.pdf";
        try {
            Desktop.getDesktop().open(new File(string2));
        }
        catch (Exception exception) {
            System.out.println("Could not open manual.");
            System.out.println("   Searduino path: " + string);
            System.out.println("   Manual file: " + string2);
            System.out.println("   Exception: " + exception);
        }
    }

    public void showJearduinoManual() {
        try {
            Desktop.getDesktop().open(new File("/opt/share/searduino/doc/jearduino.html"));
        }
        catch (IOException iOException) {
            System.out.println("Could not open jearduino manual");
        }
    }

    public int handleCodeChoice(Object object) {
        for (int i = 0; i < 10; ++i) {
            if (object != this.codeItem[i]) continue;
            System.out.println("Code at " + i + " was choosen ");
            return i;
        }
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = this.handleCodeChoice(object);
        if (object == this.leoItem || object == this.unoItem || object == this.megaItem || object == this.mega2560Item) {
            this.be.handleBoardChoiceEvent(actionEvent.getActionCommand());
        } else if (object == this.loadFromFile) {
            this.findArduinoCode();
        } else if (object == this.aboutItem) {
            this.showAbout();
        } else if (object == this.manualItem) {
            this.showManual();
        } else if (object == this.jearduinoManualItem) {
            this.showJearduinoManual();
        } else if (object == this.buildItem) {
            this.je.handleJearduinoEvent(1, null);
        } else if (object == this.importArduinoFileItem) {
            this.findInoCode();
        } else if (object == this.verifyArduinoCodeItem) {
            this.je.handleJearduinoEvent(2, null);
        } else if (object == this.uploadArduinoCodeItem) {
            this.je.handleJearduinoEvent(3, null);
        } else if (object == this.openSearduinoProjectItem) {
            this.findSerduinoProject();
        } else if (n != -1) {
            this.ae.handleArduinoCodeNameEvent(n);
        }
    }

    public void createHelpMenu() {
        this.aboutItem = new JMenuItem("About");
        this.manualItem = new JMenuItem("Searduino Manual");
        this.jearduinoManualItem = new JMenuItem("Jearduino Manual");
        this.helpMenu.add(this.aboutItem);
        this.helpMenu.add(this.manualItem);
        this.aboutItem.addActionListener(this);
        this.manualItem.addActionListener(this);
    }

    public void removeCodeItems() {
        this.codeMenu.removeAll();
    }

    public void updateCodeItem(int n, String string) {
        this.codeItem[n] = new JMenuItem(string);
        this.codeMenu.add(this.codeItem[n]);
        this.codeItem[n].addActionListener(this);
    }

    public void createBoardMenu() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.leoItem = new JRadioButtonMenuItem("Leonardo");
        this.unoItem = new JRadioButtonMenuItem("Uno");
        this.megaItem = new JRadioButtonMenuItem("Mega");
        this.mega2560Item = new JRadioButtonMenuItem("Mega2560");
        this.boardMenu.add(this.leoItem);
        this.leoItem.addActionListener(this);
        this.unoItem.addActionListener(this);
        this.megaItem.addActionListener(this);
        this.mega2560Item.addActionListener(this);
        buttonGroup.add(this.unoItem);
        buttonGroup.add(this.megaItem);
        buttonGroup.add(this.mega2560Item);
        this.boardMenu.add(this.unoItem);
        this.boardMenu.add(this.megaItem);
        this.boardMenu.add(this.mega2560Item);
    }

    public void createSearduinoMenu() {
        this.openSearduinoProjectItem = new JMenuItem("Open Searduino Project");
        this.buildItem = new JMenuItem("Build for simulator");
        this.openSearduinoProjectItem.addActionListener(this);
        this.buildItem.addActionListener(this);
        this.searduinoMenu.add(this.openSearduinoProjectItem);
        this.searduinoMenu.add(this.buildItem);
        this.searduinoMenu.add(this.codeMenu);
        this.searduinoMenu.add(this.loadFromFile);
    }

    public void createArduinoMenu() {
        this.importArduinoFileItem = new JMenuItem("Import Arduino Sketches");
        this.verifyArduinoCodeItem = new JMenuItem("Verify/build code for Arduino board");
        this.uploadArduinoCodeItem = new JMenuItem("Upload to Arduino board");
        this.importArduinoFileItem.addActionListener(this);
        this.verifyArduinoCodeItem.addActionListener(this);
        this.uploadArduinoCodeItem.addActionListener(this);
        this.arduinoMenu.add(this.importArduinoFileItem);
        this.arduinoMenu.add(this.verifyArduinoCodeItem);
        this.arduinoMenu.add(this.uploadArduinoCodeItem);
    }
}

