##parameters=overwrite=0

###########################################################################
# TextIndexNG V 3                
# The next generation TextIndex for Zope
#
# This software is governed by a license. See
# LICENSE.txt for the terms of this license.
###########################################################################

# Replace all text indexes with a TextIndexNG V3 instance

encoding = context.portal_properties.site_properties.default_charset

metatypes =  ['ZCTextIndex', 'TextIndex', 'TextIndexNG2']
if overwrite: metatypes.append('TextIndexNG3')

catalog = context.portal_catalog
indexes = catalog.getIndexObjects()
indexes = [idx for idx in indexes if idx.meta_type in metatypes]

for idx in indexes:
    old_id = idx.getId()                                    

    catalog.manage_delIndex(old_id)
    catalog.manage_addIndex(old_id, 'TextIndexNG3', extra={'default_encoding' : encoding,
                                                           'splitter_casefolding' : True,
                                                           'dedicated_storages' : True,
                                                           'use_converters' : True,
                                                           'index_unknown_languages' : True,
                                                           'storage' : 'txng.storages.term_frequencies',
                                                           'ranking' : True,
                                                           })

catalog.manage_reindexIndex([idx.getId() for idx in indexes], context.REQUEST)

context.REQUEST.RESPONSE.redirect('txng_maintenance?portal_status_message=All+text+indexes+converted+to+TextIndexNG+V3')    
