## Script (Python) "add_link"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath
##parameters=REQUEST,RESPONSE
##title=Adds Link as a reference to the course materials
##

course_ssid = REQUEST['courseid']
title = REQUEST['title']
description = REQUEST['description']
link = REQUEST['link']
try:
    referenceslist = REQUEST['references']
except:
    context.REQUEST.RESPONSE.redirect( context.portal_url() + '/'+ 'add_link_form?course_ssid='+ course_ssid +'&'+'msg='+'1' )
    return
   
  
username = REQUEST['username']



"""
	Calculating nodeid
"""

links_ssid = context.gnowql.getlatestVersion('Links')

links_info_dict = context.gnowql.getinfoFromSSID(links_ssid,'gbobjecttypes')
no_of_links = links_info_dict['instances']

if no_of_links == None:
   counter = 2
else:
   counter = len(no_of_links) + 2

link_nodeid = 'link' + str(counter)


"""
         Assigning Initial values if the user does not enter
         some information
"""

if (title == "" and link == ""):
   context.REQUEST.RESPONSE.redirect( context.portal_url() + '/'+ 'add_link_form?course_ssid='+ course_ssid +'&'+'msg='+'1' )
   return

if (title == "" or link == ""):
   context.REQUEST.RESPONSE.redirect( context.portal_url() + '/'+ 'add_link_form?course_ssid='+ course_ssid +'&'+'msg='+'1' )
   return 

if description == " ":
   description = "No Description has been added to this Link."


"""
	Getting userid from the username
"""

uid = context.gnowql.getUserIdfromUsername(username)

"""
	Preparing the dictionary for adding
	the glossary as an object
"""

dictParameters = {
		'nid':link_nodeid,
		'uid':uid,
		'status':'Public',
		'content':link,
		'title':[title],
		'description':description,
		'instanceof':['Links']
		}

context.gnowql.manageAddObject( dictParameters )


"""
	Getting the latest ssid of the object(Link)
	created.
"""

latest_link_ssid = context.gnowql.getlatestVersion( link_nodeid )
 

"""
	Preparing a dictionary of parameters for creating
        a relation between a partmaterials of the course and the Link.The
 	relationtype is 'references'.
"""

for partmaterial in referenceslist:
    dictParameters = {
                'uid':uid,
                'status':'Public',
                'subject1':partmaterial,
                'subject2':latest_link_ssid,
                'relationtypes':'references'
                 }

    context.gnowql.manageAddRelation( dictParameters )

exists = context.chkExistence(course_ssid,'link')
if exists == False:
   datadict = [{'Content':[],'Glossary':[],'Tests':[],'FaqTopics':[]},[]]
   context.pickleComponent( course_ssid , 'link' , datadict )

datadict = context.unpickleComponent( course_ssid , 'link')

for reference in referenceslist:
   reftitle = context.gnowql.getinfoFromSSID( reference, 'gbobjects')['title'][0]
   val = [[str(reference),reftitle],[[str(latest_link_ssid) , title]]]
   info_from_ssid = context.gnowql.getinfoFromSSID( reference , 'gbobjects' )
   instanceof_ssid = info_from_ssid['instanceof'][0]
   instanceof_nodeid = context.gnowql.getnidfromssid( str(instanceof_ssid) , 'gbobjecttypes')
   a=datadict[0][instanceof_nodeid]
   b=len(datadict[0][instanceof_nodeid])
   cnt=0
   try:
      for elem in a:
         if elem[0][0] == reference:
            datadict[0][instanceof_nodeid][cnt][1].append(val[1][0])
            break
         else:
            cnt=cnt+1
   except:
      cnt = b
   if cnt == b:
      datadict[0][instanceof_nodeid].append(val)
         
datadict[1].append(str(latest_link_ssid))
context.pickleComponent( course_ssid , 'link' , datadict )

context.REQUEST.RESPONSE.redirect( context.portal_url() + '/refreshparent?courseid=' + course_ssid +'&'+'page=linksview' )



